/* GAdmin-OpenVPN - An easy to use GTK+ frontend for the openvpn server.
 * Copyright (C) 2008 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/


#include "../config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include "gettext.h"
#include "widgets.h"
#include "make_settings_entries.h"
#include "make_settings_combos.h"
#include "make_settings_spinbuttons.h"
#include "make_settings_progressbars.h"
#include "make_settings_labels.h"
#include "make_settings_hseparators.h"
#include "generate_cert.h"
#include "create_server_settings.h"

extern int use_tls;



void create_server_settings(struct w *widgets)
{
    GtkTooltips *tooltips;
    GtkWidget *gen_cert_button;
    gchar *utf8 = NULL;
    gdouble progress_val = 1.0;
    gchar *combo_text;

    /* Counters for the widgets and positions in the table */
    int a = 0;
    int b = 1;
    int ent  = 0;
    int spin = 0;
    int comb = 0;

    /* Max lengths and input */
    int entry_size = 100;

    tooltips = gtk_tooltips_new();

    /* External interface name */
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" External interface name: "), 0,1,a,b,entry_size);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], 
    _("The name of the internet connected interface, IE: eth0"), NULL);
    a++; b++; ent++;

    /* External address */
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" External address: "), 0,1,a,b,entry_size);

    combo_text = g_strconcat(
    _("The external address clients will be connecting to such as:\nvpn.example.org or an IP-address.\n"),
    _("0.0.0.0 means any address on the server and can be used but is not compatible with smooth exports to clients."),
    NULL);
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], utf8, NULL);
    g_free(combo_text); g_free(utf8);
    a++; b++; ent++;

    /* Server port */
    widgets->server_set_spinbutton[spin] = make_short_spinbutton_with_label(GTK_TABLE(widgets->srv_set_table), _(" Server port: "), 0,1,a,b,50);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_spinbutton[spin], _("The port VPN clients should connect to."), NULL);
    a++; b++; spin++;

    /* LAN interface name */
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" LAN interface name: "), 0,1,a,b,entry_size);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], 
    _("The name of the LAN network interface, IE: eth1"), NULL);
    a++; b++; ent++;

    /* LAN interface address */
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" LAN interface address: "), 0,1,a,b,entry_size);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], 
    _("IE: 192.168.10.100\nYour LAN should not have the same network address as connecting clients commonly have, IE: 192.168.0 or 10.0.0. Also change this setting in your DHCP server and firewall."), NULL);
    a++; b++; ent++;

    /* LAN Subnet mask */
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" LAN subnet mask: "), 0,1,a,b,entry_size);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], 
    _("IE: 255.255.255.0"), NULL);
    a++; b++; ent++;

    /* LAN Broadcast address */
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" LAN broadcast address: "), 0,1,a,b,entry_size);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], 
    _("IE: 192.168.10.255"), NULL);
    a++; b++; ent++;

    /* VPN Clients address pool */
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" Client address range: "), 0,1,a,b,entry_size);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], 
    _("VPN clients are assigned IP-addresses on the LAN in this range, IE: 192.168.10.120 192.168.10.254"), NULL);
    a++; b++; ent++;

    /* Protocol UDP/TCP */
    widgets->server_set_combo[comb] = make_short_combo_with_label(GTK_TABLE(widgets->srv_set_table), _(" Protocol: "), 0,1,a,b,50);
    combo_text = g_strdup_printf(_("TCP"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    combo_text = g_strdup_printf(_("UDP"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    a++; b++; comb++;

    /* The TAP interface to create and use */
    widgets->server_set_combo[comb] = make_short_combo_with_label(GTK_TABLE(widgets->srv_set_table), _(" TAP Device: "), 0,1,a,b,50);
    combo_text = g_strdup_printf("Tap0");
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    combo_text = g_strdup_printf("Tap1");
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    combo_text = g_strdup_printf("Tap2");
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    combo_text = g_strdup_printf("Tap3");
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    a++; b++; comb++;

    /* Require username and password authentication */
    widgets->server_set_combo[comb] = make_short_combo_with_label(GTK_TABLE(widgets->srv_set_table), _(" Require authentication: "), 0,1,a,b,50);
    combo_text = g_strdup_printf(_("No"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    combo_text = g_strdup_printf(_("Yes"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    a++; b++; comb++;

    /* Encryption type: BlowFish, AES or Triple-DES */
    widgets->server_set_combo[comb] = make_short_combo_with_label(GTK_TABLE(widgets->srv_set_table), _(" Encryption type: "), 0,1,a,b,50);
    combo_text = g_strdup_printf(_("BlowFish"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    combo_text = g_strdup_printf(_("AES-128"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    combo_text = g_strdup_printf(_("AES-256"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    combo_text = g_strdup_printf(_("Triple-DES"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    a++; b++; comb++;

    /* Allow client to client to see eachother */
    widgets->server_set_combo[comb] = make_short_combo_with_label(GTK_TABLE(widgets->srv_set_table), _(" Clients see eachother: "), 0,1,a,b,50);
    combo_text = g_strdup_printf(_("No"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    combo_text = g_strdup_printf(_("Yes"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    a++; b++; comb++;

    /* Push "redirect-gateway" */
    widgets->server_set_combo[comb] = make_short_combo_with_label(GTK_TABLE(widgets->srv_set_table), _(" Tunnel all client traffic: "), 0,1,a,b,50);
    combo_text = g_strdup_printf(_("No"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    combo_text = g_strdup_printf(_("Yes"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    a++; b++; comb++;

    /* Use compression */
    widgets->server_set_combo[comb] = make_short_combo_with_label(GTK_TABLE(widgets->srv_set_table), _(" Use compression: "), 0,1,a,b,50);
    combo_text = g_strdup_printf(_("No"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    combo_text = g_strdup_printf(_("Yes"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    a++; b++; comb++;

    /* Share internet */
    widgets->server_set_combo[comb] = make_short_combo_with_label(GTK_TABLE(widgets->srv_set_table), _(" Share internet: "), 0,1,a,b,50);
    combo_text = g_strdup_printf(_("No"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    combo_text = g_strdup_printf(_("Yes"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    a++; b++; comb++;

    /* Using Firestarter */
    widgets->server_set_combo[comb] = make_short_combo_with_label(GTK_TABLE(widgets->srv_set_table), _(" Using Firestarter: "), 0,1,a,b,50);
    combo_text = g_strdup_printf(_("No"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    combo_text = g_strdup_printf(_("Yes"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    a++; b++; comb++;

    /* Max connections */
    widgets->server_set_spinbutton[spin] = make_short_spinbutton_with_label(GTK_TABLE(widgets->srv_set_table),_(" Max connections: "), 0,1,a,b,50);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_spinbutton[spin], _("Limits the amount of concurrent connections. 0 means no limit."), NULL);
    a++; b++; spin++;

    /* Log level (verb 3) */
    widgets->server_set_spinbutton[spin] = make_short_spinbutton_with_label(GTK_TABLE(widgets->srv_set_table),_(" Log level: "), 0,1,a,b,50);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_spinbutton[spin], _("Log verbosity level."), NULL);
    a++; b++; spin++;

    /* Ping interval */
    widgets->server_set_spinbutton[spin] = make_short_spinbutton_with_label(GTK_TABLE(widgets->srv_set_table),_(" Ping interval: "), 0,1,a,b,50);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_spinbutton[spin], _("Ping interval in seconds."), NULL);
    a++; b++; spin++;

    /* Ping timeout */
    widgets->server_set_spinbutton[spin] = make_short_spinbutton_with_label(GTK_TABLE(widgets->srv_set_table),_(" Ping timeout: "), 0,1,a,b,50);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_spinbutton[spin], _("Number of seconds a client has to reply to a ping before the server closes the connection."), NULL);
    a++; b++; spin++;


    /* Server user */
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" The server runs as this user: "), 0,1,a,b,200);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], _("The server drops root privileges and runs as this user"), NULL);
    a++; b++; ent++;

    /* Server group */
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" The server runs as this group: "), 0,1,a,b,200);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], _("The server drops root privileges and runs as this group"), NULL);
    a++; b++; ent++;


    /* A hseparator */
    make_3columns_hseparator(GTK_TABLE(widgets->srv_set_table), 0,1,a,b);
    a++; b++;

    /* The signed certificate settings */
    make_3columns_label(GTK_TABLE(widgets->srv_set_table), _(" Signed certificate settings: "), 0,1,a,b);
    a++; b++;

    /* This servers DNS name or IP-Address */
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" Server address: "), 0,1,a,b,200);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], _("This servers DNS name or IP address"), NULL);
    a++; b++; ent++;

    /* Email address */
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" Email address: "), 0,1,a,b,200);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], _("The administrators email address"), NULL);
    a++; b++; ent++;

    /* Country */
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" Country: "), 0,1,a,b,200);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], _("A country"), NULL);
    a++; b++; ent++;

    /* City or town */
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" City or town: "), 0,1,a,b,200);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], _("A city or a town"), NULL);
    a++; b++; ent++;

    /* Organization */
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" Organization: "), 0,1,a,b,200);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], _("Some organization"), NULL);
    a++; b++; ent++;

    /* Organization unit */
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" Organization unit: "), 0,1,a,b,200);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], _("A department within the organization"), NULL);
    a++; b++; ent++;

    /* Password */
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" Password: "), 0,1,a,b,200);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], _("A password"), NULL);
    a++; b++; ent++;

    /* Number of encryption bits (Min value = 384) */
    widgets->server_set_spinbutton[spin] = make_short_spinbutton_with_label(GTK_TABLE(widgets->srv_set_table),_(" Encryption bits: "), 0,1,a,b,50);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_spinbutton[spin], _("Number of bits in the generated certificate"), NULL);
    gtk_spin_button_set_range(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[spin]), 384, 999999);
    a++; b++; spin++;

    /* Number of days the certificate is valid */
    widgets->server_set_spinbutton[spin] = make_short_spinbutton_with_label(GTK_TABLE(widgets->srv_set_table),_(" Days valid: "), 0,1,a,b,50);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_spinbutton[spin], _("Number of days the certificate is valid"), NULL);
    a++; b++; spin++;

    /* Countrycode */
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" Country code: "), 0,1,a,b,200);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], _("The country code, IE: SV, DK, EN, US"), NULL);
    a++; b++; ent++;

    /* A progress bar */
    widgets->gen_cert_progressbar = make_progressbar_with_label(GTK_TABLE(widgets->srv_set_table), _(" Generate certificate: "), 0,1,a,b,210);
    gtk_widget_set_sensitive(widgets->gen_cert_progressbar, FALSE);

    /* The progress bar looks nicer if its blue from start */
    gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(widgets->gen_cert_progressbar), progress_val);

    /* An apply button for the progress bar (make_button is in make_settings_progressbars.c) */
    gen_cert_button = make_button(GTK_TABLE(widgets->srv_set_table), 0,1,a,b,200);
    a++; b++;

    g_signal_connect_swapped(G_OBJECT(gen_cert_button), "clicked",
				 G_CALLBACK(generate_cert), widgets);


    gtk_widget_show_all(widgets->main_window);
}
