/* GADMIN-DHCPD - An easy to use GTK+ frontend for ISC DHCPD.
 * Copyright (C) 2004 - 2009 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include "widgets.h"
#include "gettext.h"
#include "populate_scope_treeview.h"
#include "select_first_scope.h"
#include "clear_ptr_array.h"
#include "set_num_ranges.h"
#include "populate_ranges.h"
#include "populate_scope_settings.h"

extern char global_netmask[1024];
extern char global_subnet[1024];
extern char global_nic[1024];


void list_scopes(struct w *widgets)
{
    populate_scope_treeview(widgets);
    select_first_scope(widgets);

    clear_ptr_array(widgets);
    set_num_ranges(global_nic, global_subnet, global_netmask);
    populate_ranges(widgets, global_nic, global_subnet, global_netmask);

    populate_scope_settings(widgets);
}
