/* GADMIN-DHCPD - An easy to use GTK+ frontend for ISC DHCPD.
 * Copyright (C) 2004 - 2008 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include "../config.h"
#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include "widgets.h"
#include "gettext.h"
#include "functions.h"

extern int activated;
extern char DHCPD_CONF_BUF[1024];



void reread_conf()
{
    /* It doesnt restart/reread with a HUP, no problem */
    gchar *command, *test;

    if( ! activated )
      return;

    command = g_strdup_printf("killall -15 %s", DHCPD_BINARY);
    if( ! run_command(command) )
      printf("dhcpd shutdown failed, trying to start it\n");

    g_free(command);


    command = g_strdup_printf("%s -cf %s 2>&1", DHCPD_BINARY, DHCPD_CONF_BUF);
    if( ! run_command(command) )
    {
        printf("Restarting dhcpd failed\n");
        test = g_strdup_printf("%s -cf %s 2>&1", DHCPD_BINARY, DHCPD_CONF_BUF);
	run_command_show_err(test);
	g_free(test);
    }
    g_free(command);
}
