#! /usr/bin/perl -w

use strict ;

use vars qw/$ifile $ofile $cfile $prefix $tmpfile %hash $key $val $cur $code $line $token/ ;

# use Debconf::Client::ConfModule ':all';

if ($#ARGV < 1) {
    print STDERR "Missing parameter.\n\n" ;
    print STDERR "Usage: fill-in-the-blanks.pl <in-template> <out-file> [<conf_files>]\n" ;
    exit 1 ;
}

if ($#ARGV >= 2) {
	$ifile = shift @ARGV ;
	$ofile = shift @ARGV ;
	$cfile = shift @ARGV ;
} else {
	$ifile = shift @ARGV ;
	$ofile = shift @ARGV ;
	$cfile = "/etc/fusionforge/fusionforge.conf" ;
}
%hash = () ;

open CONF, "$cfile" ;
while ($line = <CONF>) {
    chomp $line ;
    next if $line =~ m/^\s*#/ ;
    ($key, $val) = split ('=', $line, 2) ;
    $hash{$key} = $val ;
}
close CONF ;

while ($#ARGV > -1 ) {
	$cfile = shift @ARGV ;
	open CONF, "$cfile" ;
	while ($line = <CONF>) {
    		chomp $line ;
    		next if $line =~ m/^\s*#/ ;
    		($key, $val) = split ('=', $line, 2) ;
    		$hash{$key} = $val ;
	}
	close CONF ;
}

$hash{"PLEASE DO NOT REMOVE THIS LINE"} =
    "Do not edit this file, edit /etc/gforge/templates/* and run fusionforge-config" ;

umask 0077 ;
open (IFILE, $ifile)
    or die "Can't open input file '$ifile'" ;
if (-e $ofile) {
    unlink $ofile
	or die "Can't unlink output file '$ofile'" ;
}
open (OFILE, "> $ofile")
    or die "Can't open output file '$ofile'" ;

while ($line = <IFILE>) {
    chomp $line ;
    foreach $cur (keys %hash) {
	$token = "{$cur}" ;
	$line =~ s/$token/$hash{$cur}/g ;
    }
    print OFILE "$line\n";
}
close IFILE ;
close OFILE ;
