/* plugin.c generated by valac 0.14.2, the Vala compiler
 * generated from plugin.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Michael 'Mickey' Lauer <mlauer@vanille-media.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <fsobasics.h>
#include <freesmartphone.h>
#include <fsoframework.h>
#include <fsodevice.h>
#include <fsoresource.h>
#include <gio/gio.h>


#define HARDWARE_TYPE_ACCELEROMETER (hardware_accelerometer_get_type ())
#define HARDWARE_ACCELEROMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), HARDWARE_TYPE_ACCELEROMETER, HardwareAccelerometer))
#define HARDWARE_ACCELEROMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), HARDWARE_TYPE_ACCELEROMETER, HardwareAccelerometerClass))
#define HARDWARE_IS_ACCELEROMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), HARDWARE_TYPE_ACCELEROMETER))
#define HARDWARE_IS_ACCELEROMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), HARDWARE_TYPE_ACCELEROMETER))
#define HARDWARE_ACCELEROMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), HARDWARE_TYPE_ACCELEROMETER, HardwareAccelerometerClass))

typedef struct _HardwareAccelerometer HardwareAccelerometer;
typedef struct _HardwareAccelerometerClass HardwareAccelerometerClass;
typedef struct _HardwareAccelerometerPrivate HardwareAccelerometerPrivate;

#define HARDWARE_ACCELEROMETER_TYPE_TERNARY (hardware_accelerometer_ternary_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define HARDWARE_TYPE_ACCELEROMETER_RESOURCE (hardware_accelerometer_resource_get_type ())
#define HARDWARE_ACCELEROMETER_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), HARDWARE_TYPE_ACCELEROMETER_RESOURCE, HardwareAccelerometerResource))
#define HARDWARE_ACCELEROMETER_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), HARDWARE_TYPE_ACCELEROMETER_RESOURCE, HardwareAccelerometerResourceClass))
#define HARDWARE_IS_ACCELEROMETER_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), HARDWARE_TYPE_ACCELEROMETER_RESOURCE))
#define HARDWARE_IS_ACCELEROMETER_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), HARDWARE_TYPE_ACCELEROMETER_RESOURCE))
#define HARDWARE_ACCELEROMETER_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), HARDWARE_TYPE_ACCELEROMETER_RESOURCE, HardwareAccelerometerResourceClass))

typedef struct _HardwareAccelerometerResource HardwareAccelerometerResource;
typedef struct _HardwareAccelerometerResourceClass HardwareAccelerometerResourceClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _HardwareAccelerometerGetInfoData HardwareAccelerometerGetInfoData;
typedef struct _HardwareAccelerometerGetOrientationData HardwareAccelerometerGetOrientationData;
typedef struct _HardwareAccelerometerResourcePrivate HardwareAccelerometerResourcePrivate;
typedef struct _hardware_accelerometer_resource_enableResourceData hardware_accelerometer_resource_enableResourceData;
typedef struct _hardware_accelerometer_resource_disableResourceData hardware_accelerometer_resource_disableResourceData;
typedef struct _hardware_accelerometer_resource_suspendResourceData hardware_accelerometer_resource_suspendResourceData;
typedef struct _hardware_accelerometer_resource_resumeResourceData hardware_accelerometer_resource_resumeResourceData;

struct _HardwareAccelerometer {
	FsoFrameworkAbstractObject parent_instance;
	HardwareAccelerometerPrivate * priv;
};

struct _HardwareAccelerometerClass {
	FsoFrameworkAbstractObjectClass parent_class;
};

struct _HardwareAccelerometerPrivate {
	FsoFrameworkSubsystem* subsystem;
	gint deadzone;
	gint delay;
	guint timeout;
	gboolean flat;
	gboolean landscape;
	gboolean faceup;
	gboolean reverse;
	gchar* orientation;
};

typedef enum  {
	HARDWARE_ACCELEROMETER_TERNARY_UNKNOWN,
	HARDWARE_ACCELEROMETER_TERNARY_TRUE,
	HARDWARE_ACCELEROMETER_TERNARY_FALSE
} HardwareAccelerometerTernary;

struct _HardwareAccelerometerGetInfoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	HardwareAccelerometer* self;
	GHashTable* result;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* dict;
};

struct _HardwareAccelerometerGetOrientationData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	HardwareAccelerometer* self;
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
};

struct _HardwareAccelerometerResource {
	FsoFrameworkAbstractDBusResource parent_instance;
	HardwareAccelerometerResourcePrivate * priv;
	gboolean on;
};

struct _HardwareAccelerometerResourceClass {
	FsoFrameworkAbstractDBusResourceClass parent_class;
};

struct _hardware_accelerometer_resource_enableResourceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	HardwareAccelerometerResource* self;
	gboolean _tmp0_;
	FsoFrameworkLogger* _tmp1_;
	HardwareAccelerometer* _tmp2_;
};

struct _hardware_accelerometer_resource_disableResourceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	HardwareAccelerometerResource* self;
	gboolean _tmp0_;
	FsoFrameworkLogger* _tmp1_;
	HardwareAccelerometer* _tmp2_;
};

struct _hardware_accelerometer_resource_suspendResourceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	HardwareAccelerometerResource* self;
	FsoFrameworkLogger* _tmp0_;
};

struct _hardware_accelerometer_resource_resumeResourceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	HardwareAccelerometerResource* self;
	FsoFrameworkLogger* _tmp0_;
};


static gpointer hardware_accelerometer_parent_class = NULL;
extern FsoDeviceBaseAccelerometer* hardware_accelerometer_accelerometer;
FsoDeviceBaseAccelerometer* hardware_accelerometer_accelerometer = NULL;
static FreeSmartphoneDeviceOrientationIface* hardware_accelerometer_free_smartphone_device_orientation_parent_iface = NULL;
static FreeSmartphoneInfoIface* hardware_accelerometer_free_smartphone_info_parent_iface = NULL;
static GType hardware_accelerometer_type_id = 0;
static gpointer hardware_accelerometer_resource_parent_class = NULL;
extern HardwareAccelerometer* instance;
static GType hardware_accelerometer_resource_type_id = 0;
HardwareAccelerometer* instance = NULL;
extern HardwareAccelerometerResource* accelerometer;
HardwareAccelerometerResource* accelerometer = NULL;

#define HARDWARE_HW_ACCEL_PLUGIN_NAME "fsodevice.accelerometer"
#define HARDWARE_DEFAULT_DEADZONE 180
#define HARDWARE_DEFAULT_DELAY 1000
GType hardware_accelerometer_get_type (void) G_GNUC_CONST;
GType hardware_accelerometer_register_type (GTypeModule * module);
#define HARDWARE_ACCELEROMETER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), HARDWARE_TYPE_ACCELEROMETER, HardwareAccelerometerPrivate))
enum  {
	HARDWARE_ACCELEROMETER_DUMMY_PROPERTY
};
GType hardware_accelerometer_ternary_get_type (void) G_GNUC_CONST;
HardwareAccelerometer* hardware_accelerometer_new (FsoFrameworkSubsystem* subsystem);
HardwareAccelerometer* hardware_accelerometer_construct (GType object_type, FsoFrameworkSubsystem* subsystem);
void hardware_accelerometer_generateOrientationSignal (HardwareAccelerometer* self, gboolean flat, gboolean landscape, gboolean faceup, gboolean reverse);
static gchar* hardware_accelerometer_real_repr (FsoFrameworkAbstractObject* base);
static void hardware_accelerometer_startAccelerometer (HardwareAccelerometer* self);
void hardware_accelerometer_onAcceleration (HardwareAccelerometer* self, gint x, gint y, gint z);
static void _hardware_accelerometer_onAcceleration_fso_device_base_accelerometer_accelerate (FsoDeviceBaseAccelerometer* _sender, gint x, gint y, gint z, gpointer self);
static void hardware_accelerometer_stopAccelerometer (HardwareAccelerometer* self);
GType hardware_accelerometer_resource_get_type (void) G_GNUC_CONST;
GType hardware_accelerometer_resource_register_type (GTypeModule * module);
void hardware_accelerometer_onResourceChanged (HardwareAccelerometer* self, HardwareAccelerometerResource* r, gboolean enabled);
static HardwareAccelerometerTernary hardware_accelerometer_polarity (HardwareAccelerometer* self, gint value);
static gboolean hardware_accelerometer_onTimeout (HardwareAccelerometer* self);
static gboolean _hardware_accelerometer_onTimeout_gsource_func (gpointer self);
static void hardware_accelerometer_real_get_info_data_free (gpointer _data);
static void hardware_accelerometer_real_get_info (FreeSmartphoneInfo* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean hardware_accelerometer_real_get_info_co (HardwareAccelerometerGetInfoData* _data_);
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
static void hardware_accelerometer_real_get_orientation_data_free (gpointer _data);
static void hardware_accelerometer_real_get_orientation (FreeSmartphoneDeviceOrientation* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean hardware_accelerometer_real_get_orientation_co (HardwareAccelerometerGetOrientationData* _data_);
static void hardware_accelerometer_finalize (GObject* obj);
enum  {
	HARDWARE_ACCELEROMETER_RESOURCE_DUMMY_PROPERTY
};
HardwareAccelerometerResource* hardware_accelerometer_resource_new (FsoFrameworkSubsystem* subsystem);
HardwareAccelerometerResource* hardware_accelerometer_resource_construct (GType object_type, FsoFrameworkSubsystem* subsystem);
static void hardware_accelerometer_resource_real_enableResource_data_free (gpointer _data);
static void hardware_accelerometer_resource_real_enableResource (FsoFrameworkAbstractDBusResource* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean hardware_accelerometer_resource_real_enableResource_co (hardware_accelerometer_resource_enableResourceData* _data_);
static void hardware_accelerometer_resource_real_disableResource_data_free (gpointer _data);
static void hardware_accelerometer_resource_real_disableResource (FsoFrameworkAbstractDBusResource* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean hardware_accelerometer_resource_real_disableResource_co (hardware_accelerometer_resource_disableResourceData* _data_);
static void hardware_accelerometer_resource_real_suspendResource_data_free (gpointer _data);
static void hardware_accelerometer_resource_real_suspendResource (FsoFrameworkAbstractDBusResource* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean hardware_accelerometer_resource_real_suspendResource_co (hardware_accelerometer_resource_suspendResourceData* _data_);
static void hardware_accelerometer_resource_real_resumeResource_data_free (gpointer _data);
static void hardware_accelerometer_resource_real_resumeResource (FsoFrameworkAbstractDBusResource* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean hardware_accelerometer_resource_real_resumeResource_co (hardware_accelerometer_resource_resumeResourceData* _data_);
static void hardware_accelerometer_resource_finalize (GObject* obj);
gchar* fso_factory_function (FsoFrameworkSubsystem* subsystem, GError** error);
void fso_register_function (GTypeModule* module);


GType hardware_accelerometer_ternary_get_type (void) {
	static volatile gsize hardware_accelerometer_ternary_type_id__volatile = 0;
	if (g_once_init_enter (&hardware_accelerometer_ternary_type_id__volatile)) {
		static const GEnumValue values[] = {{HARDWARE_ACCELEROMETER_TERNARY_UNKNOWN, "HARDWARE_ACCELEROMETER_TERNARY_UNKNOWN", "unknown"}, {HARDWARE_ACCELEROMETER_TERNARY_TRUE, "HARDWARE_ACCELEROMETER_TERNARY_TRUE", "true"}, {HARDWARE_ACCELEROMETER_TERNARY_FALSE, "HARDWARE_ACCELEROMETER_TERNARY_FALSE", "false"}, {0, NULL, NULL}};
		GType hardware_accelerometer_ternary_type_id;
		hardware_accelerometer_ternary_type_id = g_enum_register_static ("HardwareAccelerometerTernary", values);
		g_once_init_leave (&hardware_accelerometer_ternary_type_id__volatile, hardware_accelerometer_ternary_type_id);
	}
	return hardware_accelerometer_ternary_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


HardwareAccelerometer* hardware_accelerometer_construct (GType object_type, FsoFrameworkSubsystem* subsystem) {
	HardwareAccelerometer * self = NULL;
	FsoFrameworkSubsystem* _tmp0_;
	FsoFrameworkSubsystem* _tmp1_;
	FsoFrameworkSubsystem* _tmp2_;
	FsoFrameworkSubsystem* _tmp3_;
	FsoFrameworkSmartKeyFile* _tmp4_;
	gint _tmp5_ = 0;
	FsoFrameworkSmartKeyFile* _tmp6_;
	gint _tmp7_ = 0;
	FsoFrameworkLogger* _tmp8_;
	g_return_val_if_fail (subsystem != NULL, NULL);
	self = (HardwareAccelerometer*) fso_framework_abstract_object_construct (object_type);
	_tmp0_ = subsystem;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->subsystem);
	self->priv->subsystem = _tmp1_;
	_tmp2_ = subsystem;
	fso_framework_subsystem_registerObjectForService (_tmp2_, FREE_SMARTPHONE_TYPE_INFO, (GBoxedCopyFunc) g_object_ref, g_object_unref, FSO_FRAMEWORK_DEVICE_ServiceDBusName, FSO_FRAMEWORK_DEVICE_OrientationServicePath, (FreeSmartphoneInfo*) self);
	_tmp3_ = subsystem;
	fso_framework_subsystem_registerObjectForService (_tmp3_, FREE_SMARTPHONE_DEVICE_TYPE_ORIENTATION, (GBoxedCopyFunc) g_object_ref, g_object_unref, FSO_FRAMEWORK_DEVICE_ServiceDBusName, FSO_FRAMEWORK_DEVICE_OrientationServicePath, (FreeSmartphoneDeviceOrientation*) self);
	_tmp4_ = ((FsoFrameworkAbstractObject*) self)->config;
	_tmp5_ = fso_framework_smart_key_file_intValue (_tmp4_, HARDWARE_HW_ACCEL_PLUGIN_NAME, "deadzone", HARDWARE_DEFAULT_DEADZONE);
	self->priv->deadzone = _tmp5_;
	_tmp6_ = ((FsoFrameworkAbstractObject*) self)->config;
	_tmp7_ = fso_framework_smart_key_file_intValue (_tmp6_, HARDWARE_HW_ACCEL_PLUGIN_NAME, "delay", HARDWARE_DEFAULT_DELAY);
	self->priv->delay = _tmp7_;
	hardware_accelerometer_generateOrientationSignal (self, FALSE, FALSE, TRUE, FALSE);
	_tmp8_ = ((FsoFrameworkAbstractObject*) self)->logger;
	fso_framework_logger_info (_tmp8_, "Created new Orientation object.");
	return self;
}


HardwareAccelerometer* hardware_accelerometer_new (FsoFrameworkSubsystem* subsystem) {
	return hardware_accelerometer_construct (HARDWARE_TYPE_ACCELEROMETER, subsystem);
}


static gchar* hardware_accelerometer_real_repr (FsoFrameworkAbstractObject* base) {
	HardwareAccelerometer * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	FsoDeviceBaseAccelerometer* _tmp1_;
	self = (HardwareAccelerometer*) base;
	_tmp1_ = hardware_accelerometer_accelerometer;
	if (_tmp1_ != NULL) {
		FsoDeviceBaseAccelerometer* _tmp2_;
		GType _tmp3_ = 0UL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp2_ = hardware_accelerometer_accelerometer;
		_tmp3_ = G_TYPE_FROM_INSTANCE (_tmp2_);
		_tmp4_ = g_type_name (_tmp3_);
		_tmp5_ = g_strdup_printf ("<%s>", _tmp4_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp5_;
	} else {
		gchar* _tmp6_;
		_tmp6_ = g_strdup ("");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp6_;
	}
	result = _tmp0_;
	return result;
}


static void _hardware_accelerometer_onAcceleration_fso_device_base_accelerometer_accelerate (FsoDeviceBaseAccelerometer* _sender, gint x, gint y, gint z, gpointer self) {
	hardware_accelerometer_onAcceleration (self, x, y, z);
}


static void hardware_accelerometer_startAccelerometer (HardwareAccelerometer* self) {
	FsoDeviceBaseAccelerometer* _tmp0_;
	FsoDeviceBaseAccelerometer* _tmp29_;
	g_return_if_fail (self != NULL);
	_tmp0_ = hardware_accelerometer_accelerometer;
	if (_tmp0_ == NULL) {
		FsoFrameworkSmartKeyFile* _tmp1_;
		gchar* _tmp2_ = NULL;
		gchar* devicetype;
		gchar* _tmp3_;
		gchar* typename;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		GQuark _tmp7_ = 0U;
		static GQuark _tmp6_label0 = 0;
		static GQuark _tmp6_label1 = 0;
		const gchar* _tmp14_;
		GType _tmp15_ = 0UL;
		GType classtype;
		GType _tmp16_;
		GType _tmp21_;
		GObject* _tmp22_ = NULL;
		GObject* _tmp23_;
		FsoFrameworkLogger* _tmp24_;
		const gchar* _tmp25_;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_;
		FsoDeviceBaseAccelerometer* _tmp28_;
		_tmp1_ = ((FsoFrameworkAbstractObject*) self)->config;
		_tmp2_ = fso_framework_smart_key_file_stringValue (_tmp1_, HARDWARE_HW_ACCEL_PLUGIN_NAME, "device_type", "(not set)");
		devicetype = _tmp2_;
		_tmp3_ = g_strdup ("");
		typename = _tmp3_;
		_tmp4_ = devicetype;
		_tmp5_ = _tmp4_;
		_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
		if (_tmp7_ == ((0 != _tmp6_label0) ? _tmp6_label0 : (_tmp6_label0 = g_quark_from_static_string ("lis302")))) {
			switch (0) {
				default:
				{
					gchar* _tmp8_;
					_tmp8_ = g_strdup ("HardwareAccelerometerLis302");
					_g_free0 (typename);
					typename = _tmp8_;
					break;
				}
			}
		} else if (_tmp7_ == ((0 != _tmp6_label1) ? _tmp6_label1 : (_tmp6_label1 = g_quark_from_static_string ("kxsd9")))) {
			switch (0) {
				default:
				{
					gchar* _tmp9_;
					_tmp9_ = g_strdup ("HardwareAccelerometerKxsd9");
					_g_free0 (typename);
					typename = _tmp9_;
					break;
				}
			}
		} else {
			switch (0) {
				default:
				{
					FsoFrameworkLogger* _tmp10_;
					const gchar* _tmp11_;
					gchar* _tmp12_ = NULL;
					gchar* _tmp13_;
					_tmp10_ = ((FsoFrameworkAbstractObject*) self)->logger;
					_tmp11_ = devicetype;
					_tmp12_ = g_strdup_printf ("Unknown accelerometer device type '%s'", _tmp11_);
					_tmp13_ = _tmp12_;
					fso_framework_logger_error (_tmp10_, _tmp13_);
					_g_free0 (_tmp13_);
					_g_free0 (typename);
					_g_free0 (devicetype);
					return;
				}
			}
		}
		_tmp14_ = typename;
		_tmp15_ = g_type_from_name (_tmp14_);
		classtype = _tmp15_;
		_tmp16_ = classtype;
		if (_tmp16_ == G_TYPE_INVALID) {
			FsoFrameworkLogger* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_;
			_tmp17_ = ((FsoFrameworkAbstractObject*) self)->logger;
			_tmp18_ = devicetype;
			_tmp19_ = g_strdup_printf ("Can't find plugin for accelerometer device type '%s'", _tmp18_);
			_tmp20_ = _tmp19_;
			fso_framework_logger_warning (_tmp17_, _tmp20_);
			_g_free0 (_tmp20_);
			_g_free0 (typename);
			_g_free0 (devicetype);
			return;
		}
		_tmp21_ = classtype;
		_tmp22_ = g_object_new (_tmp21_, NULL);
		_tmp23_ = G_IS_INITIALLY_UNOWNED (_tmp22_) ? g_object_ref_sink (_tmp22_) : _tmp22_;
		_g_object_unref0 (hardware_accelerometer_accelerometer);
		hardware_accelerometer_accelerometer = FSO_DEVICE_IS_BASE_ACCELEROMETER (_tmp23_) ? ((FsoDeviceBaseAccelerometer*) _tmp23_) : NULL;
		_tmp24_ = ((FsoFrameworkAbstractObject*) self)->logger;
		_tmp25_ = devicetype;
		_tmp26_ = g_strdup_printf ("Ready. Using accelerometer plugin '%s'", _tmp25_);
		_tmp27_ = _tmp26_;
		fso_framework_logger_info (_tmp24_, _tmp27_);
		_g_free0 (_tmp27_);
		_tmp28_ = hardware_accelerometer_accelerometer;
		g_signal_connect_object (_tmp28_, "accelerate", (GCallback) _hardware_accelerometer_onAcceleration_fso_device_base_accelerometer_accelerate, self, 0);
		_g_free0 (typename);
		_g_free0 (devicetype);
	}
	_tmp29_ = hardware_accelerometer_accelerometer;
	fso_device_base_accelerometer_start (_tmp29_);
}


static void hardware_accelerometer_stopAccelerometer (HardwareAccelerometer* self) {
	FsoDeviceBaseAccelerometer* _tmp0_;
	FsoDeviceBaseAccelerometer* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = hardware_accelerometer_accelerometer;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = hardware_accelerometer_accelerometer;
	fso_device_base_accelerometer_stop (_tmp1_);
}


void hardware_accelerometer_onResourceChanged (HardwareAccelerometer* self, HardwareAccelerometerResource* r, gboolean enabled) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (r != NULL);
	_tmp0_ = enabled;
	if (_tmp0_) {
		hardware_accelerometer_startAccelerometer (self);
	} else {
		hardware_accelerometer_stopAccelerometer (self);
	}
}


void hardware_accelerometer_onAcceleration (HardwareAccelerometer* self, gint x, gint y, gint z) {
	gint _tmp0_;
	HardwareAccelerometerTernary _tmp1_ = 0;
	HardwareAccelerometerTernary xpol;
	gint _tmp2_;
	HardwareAccelerometerTernary _tmp3_ = 0;
	HardwareAccelerometerTernary ypol;
	gint _tmp4_;
	HardwareAccelerometerTernary _tmp5_ = 0;
	HardwareAccelerometerTernary zpol;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	HardwareAccelerometerTernary _tmp8_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	gboolean flat;
	gboolean _tmp12_ = FALSE;
	HardwareAccelerometerTernary _tmp13_;
	gboolean _tmp16_;
	gboolean faceup;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	HardwareAccelerometerTernary _tmp19_;
	gboolean _tmp21_;
	gboolean _tmp27_;
	gboolean landscape;
	gboolean _tmp28_ = FALSE;
	HardwareAccelerometerTernary _tmp29_;
	gboolean _tmp32_;
	gboolean reverse;
	gboolean _tmp33_;
	gboolean _tmp34_;
	gboolean _tmp35_;
	g_return_if_fail (self != NULL);
	_tmp0_ = x;
	_tmp1_ = hardware_accelerometer_polarity (self, _tmp0_);
	xpol = _tmp1_;
	_tmp2_ = y;
	_tmp3_ = hardware_accelerometer_polarity (self, _tmp2_);
	ypol = _tmp3_;
	_tmp4_ = z;
	_tmp5_ = hardware_accelerometer_polarity (self, _tmp4_);
	zpol = _tmp5_;
	_tmp8_ = xpol;
	if (_tmp8_ == HARDWARE_ACCELEROMETER_TERNARY_UNKNOWN) {
		HardwareAccelerometerTernary _tmp9_;
		_tmp9_ = ypol;
		_tmp7_ = _tmp9_ == HARDWARE_ACCELEROMETER_TERNARY_UNKNOWN;
	} else {
		_tmp7_ = FALSE;
	}
	_tmp10_ = _tmp7_;
	if (_tmp10_) {
		_tmp6_ = TRUE;
	} else {
		_tmp6_ = FALSE;
	}
	_tmp11_ = _tmp6_;
	flat = _tmp11_;
	_tmp13_ = zpol;
	if (_tmp13_ == HARDWARE_ACCELEROMETER_TERNARY_UNKNOWN) {
		gboolean _tmp14_;
		_tmp14_ = self->priv->faceup;
		_tmp12_ = _tmp14_;
	} else {
		HardwareAccelerometerTernary _tmp15_;
		_tmp15_ = zpol;
		_tmp12_ = _tmp15_ == HARDWARE_ACCELEROMETER_TERNARY_TRUE;
	}
	_tmp16_ = _tmp12_;
	faceup = _tmp16_;
	_tmp19_ = xpol;
	if (_tmp19_ == HARDWARE_ACCELEROMETER_TERNARY_UNKNOWN) {
		_tmp18_ = TRUE;
	} else {
		HardwareAccelerometerTernary _tmp20_;
		_tmp20_ = ypol;
		_tmp18_ = _tmp20_ == HARDWARE_ACCELEROMETER_TERNARY_UNKNOWN;
	}
	_tmp21_ = _tmp18_;
	if (_tmp21_) {
		gboolean _tmp22_;
		_tmp22_ = self->priv->landscape;
		_tmp17_ = _tmp22_;
	} else {
		gboolean _tmp23_ = FALSE;
		HardwareAccelerometerTernary _tmp24_;
		HardwareAccelerometerTernary _tmp25_;
		gboolean _tmp26_;
		_tmp24_ = xpol;
		_tmp25_ = ypol;
		if (_tmp24_ != _tmp25_) {
			_tmp23_ = TRUE;
		} else {
			_tmp23_ = FALSE;
		}
		_tmp26_ = _tmp23_;
		_tmp17_ = _tmp26_;
	}
	_tmp27_ = _tmp17_;
	landscape = _tmp27_;
	_tmp29_ = xpol;
	if (_tmp29_ == HARDWARE_ACCELEROMETER_TERNARY_UNKNOWN) {
		gboolean _tmp30_;
		_tmp30_ = self->priv->reverse;
		_tmp28_ = _tmp30_;
	} else {
		HardwareAccelerometerTernary _tmp31_;
		_tmp31_ = xpol;
		_tmp28_ = _tmp31_ == HARDWARE_ACCELEROMETER_TERNARY_TRUE;
	}
	_tmp32_ = _tmp28_;
	reverse = _tmp32_;
	_tmp33_ = flat;
	_tmp34_ = landscape;
	_tmp35_ = faceup;
	hardware_accelerometer_generateOrientationSignal (self, _tmp33_, _tmp34_, _tmp35_, reverse);
}


static HardwareAccelerometerTernary hardware_accelerometer_polarity (HardwareAccelerometer* self, gint value) {
	HardwareAccelerometerTernary result = 0;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint _tmp2_;
	gboolean _tmp5_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = value;
	_tmp2_ = self->priv->deadzone;
	if (_tmp1_ < (-_tmp2_)) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp3_;
		gint _tmp4_;
		_tmp3_ = value;
		_tmp4_ = self->priv->deadzone;
		_tmp0_ = _tmp3_ > _tmp4_;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		HardwareAccelerometerTernary _tmp6_ = 0;
		gint _tmp7_;
		HardwareAccelerometerTernary _tmp8_;
		_tmp7_ = value;
		if (_tmp7_ > 0) {
			_tmp6_ = HARDWARE_ACCELEROMETER_TERNARY_TRUE;
		} else {
			_tmp6_ = HARDWARE_ACCELEROMETER_TERNARY_FALSE;
		}
		_tmp8_ = _tmp6_;
		result = _tmp8_;
		return result;
	}
	result = HARDWARE_ACCELEROMETER_TERNARY_UNKNOWN;
	return result;
}


static gboolean _hardware_accelerometer_onTimeout_gsource_func (gpointer self) {
	gboolean result;
	result = hardware_accelerometer_onTimeout (self);
	return result;
}


void hardware_accelerometer_generateOrientationSignal (HardwareAccelerometer* self, gboolean flat, gboolean landscape, gboolean faceup, gboolean reverse) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp7_;
	gboolean _tmp10_;
	gboolean _tmp13_;
	gboolean change;
	const gchar* _tmp14_ = NULL;
	gboolean _tmp15_;
	const gchar* _tmp16_ = NULL;
	gboolean _tmp17_;
	const gchar* _tmp18_ = NULL;
	gboolean _tmp19_;
	const gchar* _tmp20_ = NULL;
	gboolean _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_ = NULL;
	gboolean _tmp27_;
	gboolean _tmp28_;
	gboolean _tmp29_;
	gboolean _tmp30_;
	gboolean _tmp31_;
	gint _tmp32_;
	guint _tmp34_;
	gint _tmp36_;
	guint _tmp37_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp3_ = flat;
	_tmp4_ = self->priv->flat;
	if (_tmp3_ != _tmp4_) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp5_ = faceup;
		_tmp6_ = self->priv->faceup;
		_tmp2_ = _tmp5_ != _tmp6_;
	}
	_tmp7_ = _tmp2_;
	if (_tmp7_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp8_ = landscape;
		_tmp9_ = self->priv->landscape;
		_tmp1_ = _tmp8_ != _tmp9_;
	}
	_tmp10_ = _tmp1_;
	if (_tmp10_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp11_;
		gboolean _tmp12_;
		_tmp11_ = reverse;
		_tmp12_ = self->priv->reverse;
		_tmp0_ = _tmp11_ != _tmp12_;
	}
	_tmp13_ = _tmp0_;
	change = _tmp13_;
	_tmp15_ = flat;
	if (_tmp15_) {
		_tmp14_ = "flat";
	} else {
		_tmp14_ = "held";
	}
	_tmp17_ = faceup;
	if (_tmp17_) {
		_tmp16_ = "faceup";
	} else {
		_tmp16_ = "facedown";
	}
	_tmp19_ = landscape;
	if (_tmp19_) {
		_tmp18_ = "landscape";
	} else {
		_tmp18_ = "portrait";
	}
	_tmp21_ = reverse;
	if (_tmp21_) {
		_tmp20_ = "reverse";
	} else {
		_tmp20_ = "normal";
	}
	_tmp22_ = _tmp14_;
	_tmp23_ = _tmp16_;
	_tmp24_ = _tmp18_;
	_tmp25_ = _tmp20_;
	_tmp26_ = g_strdup_printf ("%s %s %s %s", _tmp22_, _tmp23_, _tmp24_, _tmp25_);
	_g_free0 (self->priv->orientation);
	self->priv->orientation = _tmp26_;
	_tmp27_ = flat;
	self->priv->flat = _tmp27_;
	_tmp28_ = faceup;
	self->priv->faceup = _tmp28_;
	_tmp29_ = landscape;
	self->priv->landscape = _tmp29_;
	_tmp30_ = reverse;
	self->priv->reverse = _tmp30_;
	_tmp31_ = change;
	if (!_tmp31_) {
		return;
	}
	_tmp32_ = self->priv->delay;
	if (_tmp32_ == 0) {
		const gchar* _tmp33_;
		_tmp33_ = self->priv->orientation;
		g_signal_emit_by_name ((FreeSmartphoneDeviceOrientation*) self, "orientation-changed", _tmp33_);
		return;
	}
	_tmp34_ = self->priv->timeout;
	if (_tmp34_ != ((guint) 0)) {
		guint _tmp35_;
		_tmp35_ = self->priv->timeout;
		g_source_remove (_tmp35_);
	}
	_tmp36_ = self->priv->delay;
	_tmp37_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) _tmp36_, _hardware_accelerometer_onTimeout_gsource_func, g_object_ref (self), g_object_unref);
	self->priv->timeout = _tmp37_;
}


static gboolean hardware_accelerometer_onTimeout (HardwareAccelerometer* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->orientation;
	g_signal_emit_by_name ((FreeSmartphoneDeviceOrientation*) self, "orientation-changed", _tmp0_);
	self->priv->timeout = (guint) 0;
	result = FALSE;
	return result;
}


static void hardware_accelerometer_real_get_info_data_free (gpointer _data) {
	HardwareAccelerometerGetInfoData* _data_;
	_data_ = _data;
	_g_hash_table_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (HardwareAccelerometerGetInfoData, _data_);
}


static void hardware_accelerometer_real_get_info (FreeSmartphoneInfo* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	HardwareAccelerometer * self;
	HardwareAccelerometerGetInfoData* _data_;
	HardwareAccelerometer* _tmp0_;
	self = (HardwareAccelerometer*) base;
	_data_ = g_slice_new0 (HardwareAccelerometerGetInfoData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, hardware_accelerometer_real_get_info);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, hardware_accelerometer_real_get_info_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	hardware_accelerometer_real_get_info_co (_data_);
}


static GHashTable* hardware_accelerometer_real_get_info_finish (FreeSmartphoneInfo* base, GAsyncResult* _res_, GError** error) {
	GHashTable* result;
	HardwareAccelerometerGetInfoData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_variant_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}


static gboolean hardware_accelerometer_real_get_info_co (HardwareAccelerometerGetInfoData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_str_hash;
	_data_->_tmp1_ = g_str_equal;
	_data_->_tmp2_ = g_hash_table_new_full (_data_->_tmp0_, _data_->_tmp1_, _g_free0_, _g_variant_unref0_);
	_data_->dict = _data_->_tmp2_;
	_data_->result = _data_->dict;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_hash_table_unref0 (_data_->dict);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void hardware_accelerometer_real_get_orientation_data_free (gpointer _data) {
	HardwareAccelerometerGetOrientationData* _data_;
	_data_ = _data;
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (HardwareAccelerometerGetOrientationData, _data_);
}


static void hardware_accelerometer_real_get_orientation (FreeSmartphoneDeviceOrientation* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	HardwareAccelerometer * self;
	HardwareAccelerometerGetOrientationData* _data_;
	HardwareAccelerometer* _tmp0_;
	self = (HardwareAccelerometer*) base;
	_data_ = g_slice_new0 (HardwareAccelerometerGetOrientationData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, hardware_accelerometer_real_get_orientation);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, hardware_accelerometer_real_get_orientation_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	hardware_accelerometer_real_get_orientation_co (_data_);
}


static gchar* hardware_accelerometer_real_get_orientation_finish (FreeSmartphoneDeviceOrientation* base, GAsyncResult* _res_, GError** error) {
	gchar* result;
	HardwareAccelerometerGetOrientationData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static gboolean hardware_accelerometer_real_get_orientation_co (HardwareAccelerometerGetOrientationData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->orientation;
	_data_->_tmp1_ = g_strdup (_data_->_tmp0_);
	_data_->result = _data_->_tmp1_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void hardware_accelerometer_class_init (HardwareAccelerometerClass * klass) {
	hardware_accelerometer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (HardwareAccelerometerPrivate));
	FSO_FRAMEWORK_ABSTRACT_OBJECT_CLASS (klass)->repr = hardware_accelerometer_real_repr;
	G_OBJECT_CLASS (klass)->finalize = hardware_accelerometer_finalize;
}


static void hardware_accelerometer_free_smartphone_device_orientation_interface_init (FreeSmartphoneDeviceOrientationIface * iface) {
	hardware_accelerometer_free_smartphone_device_orientation_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_orientation = (gchar* (*)(FreeSmartphoneDeviceOrientation*, GError**)) hardware_accelerometer_real_get_orientation;
	iface->get_orientation_finish = hardware_accelerometer_real_get_orientation_finish;
}


static void hardware_accelerometer_free_smartphone_info_interface_init (FreeSmartphoneInfoIface * iface) {
	hardware_accelerometer_free_smartphone_info_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_info = (GHashTable* (*)(FreeSmartphoneInfo*, GError**)) hardware_accelerometer_real_get_info;
	iface->get_info_finish = hardware_accelerometer_real_get_info_finish;
}


static void hardware_accelerometer_instance_init (HardwareAccelerometer * self) {
	self->priv = HARDWARE_ACCELEROMETER_GET_PRIVATE (self);
}


static void hardware_accelerometer_finalize (GObject* obj) {
	HardwareAccelerometer * self;
	self = HARDWARE_ACCELEROMETER (obj);
	_g_object_unref0 (self->priv->subsystem);
	_g_free0 (self->priv->orientation);
	G_OBJECT_CLASS (hardware_accelerometer_parent_class)->finalize (obj);
}


/**
 * Implementation of org.freesmartphone.Device.Orientation for an Accelerometer device
 **/
GType hardware_accelerometer_get_type (void) {
	return hardware_accelerometer_type_id;
}


GType hardware_accelerometer_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (HardwareAccelerometerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) hardware_accelerometer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (HardwareAccelerometer), 0, (GInstanceInitFunc) hardware_accelerometer_instance_init, NULL };
	static const GInterfaceInfo free_smartphone_device_orientation_info = { (GInterfaceInitFunc) hardware_accelerometer_free_smartphone_device_orientation_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo free_smartphone_info_info = { (GInterfaceInitFunc) hardware_accelerometer_free_smartphone_info_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	hardware_accelerometer_type_id = g_type_module_register_type (module, FSO_FRAMEWORK_TYPE_ABSTRACT_OBJECT, "HardwareAccelerometer", &g_define_type_info, 0);
	g_type_module_add_interface (module, hardware_accelerometer_type_id, FREE_SMARTPHONE_DEVICE_TYPE_ORIENTATION, &free_smartphone_device_orientation_info);
	g_type_module_add_interface (module, hardware_accelerometer_type_id, FREE_SMARTPHONE_TYPE_INFO, &free_smartphone_info_info);
	return hardware_accelerometer_type_id;
}


HardwareAccelerometerResource* hardware_accelerometer_resource_construct (GType object_type, FsoFrameworkSubsystem* subsystem) {
	HardwareAccelerometerResource * self = NULL;
	FsoFrameworkSubsystem* _tmp0_;
	g_return_val_if_fail (subsystem != NULL, NULL);
	_tmp0_ = subsystem;
	self = (HardwareAccelerometerResource*) fso_framework_abstract_dbus_resource_construct (object_type, "Accelerometer", _tmp0_);
	return self;
}


HardwareAccelerometerResource* hardware_accelerometer_resource_new (FsoFrameworkSubsystem* subsystem) {
	return hardware_accelerometer_resource_construct (HARDWARE_TYPE_ACCELEROMETER_RESOURCE, subsystem);
}


static void hardware_accelerometer_resource_real_enableResource_data_free (gpointer _data) {
	hardware_accelerometer_resource_enableResourceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (hardware_accelerometer_resource_enableResourceData, _data_);
}


static void hardware_accelerometer_resource_real_enableResource (FsoFrameworkAbstractDBusResource* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	HardwareAccelerometerResource * self;
	hardware_accelerometer_resource_enableResourceData* _data_;
	HardwareAccelerometerResource* _tmp0_;
	self = (HardwareAccelerometerResource*) base;
	_data_ = g_slice_new0 (hardware_accelerometer_resource_enableResourceData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, hardware_accelerometer_resource_real_enableResource);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, hardware_accelerometer_resource_real_enableResource_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	hardware_accelerometer_resource_real_enableResource_co (_data_);
}


static void hardware_accelerometer_resource_real_enableResource_finish (FsoFrameworkAbstractDBusResource* base, GAsyncResult* _res_, GError** error) {
	hardware_accelerometer_resource_enableResourceData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean hardware_accelerometer_resource_real_enableResource_co (hardware_accelerometer_resource_enableResourceData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->on;
	if (_data_->_tmp0_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
	fso_framework_logger_debug (_data_->_tmp1_, "enabling...");
	_data_->_tmp2_ = instance;
	hardware_accelerometer_onResourceChanged (_data_->_tmp2_, _data_->self, TRUE);
	_data_->self->on = TRUE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void hardware_accelerometer_resource_real_disableResource_data_free (gpointer _data) {
	hardware_accelerometer_resource_disableResourceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (hardware_accelerometer_resource_disableResourceData, _data_);
}


static void hardware_accelerometer_resource_real_disableResource (FsoFrameworkAbstractDBusResource* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	HardwareAccelerometerResource * self;
	hardware_accelerometer_resource_disableResourceData* _data_;
	HardwareAccelerometerResource* _tmp0_;
	self = (HardwareAccelerometerResource*) base;
	_data_ = g_slice_new0 (hardware_accelerometer_resource_disableResourceData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, hardware_accelerometer_resource_real_disableResource);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, hardware_accelerometer_resource_real_disableResource_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	hardware_accelerometer_resource_real_disableResource_co (_data_);
}


static void hardware_accelerometer_resource_real_disableResource_finish (FsoFrameworkAbstractDBusResource* base, GAsyncResult* _res_) {
	hardware_accelerometer_resource_disableResourceData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean hardware_accelerometer_resource_real_disableResource_co (hardware_accelerometer_resource_disableResourceData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->on;
	if (!_data_->_tmp0_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
	fso_framework_logger_debug (_data_->_tmp1_, "disabling...");
	_data_->_tmp2_ = instance;
	hardware_accelerometer_onResourceChanged (_data_->_tmp2_, _data_->self, FALSE);
	_data_->self->on = FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void hardware_accelerometer_resource_real_suspendResource_data_free (gpointer _data) {
	hardware_accelerometer_resource_suspendResourceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (hardware_accelerometer_resource_suspendResourceData, _data_);
}


static void hardware_accelerometer_resource_real_suspendResource (FsoFrameworkAbstractDBusResource* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	HardwareAccelerometerResource * self;
	hardware_accelerometer_resource_suspendResourceData* _data_;
	HardwareAccelerometerResource* _tmp0_;
	self = (HardwareAccelerometerResource*) base;
	_data_ = g_slice_new0 (hardware_accelerometer_resource_suspendResourceData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, hardware_accelerometer_resource_real_suspendResource);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, hardware_accelerometer_resource_real_suspendResource_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	hardware_accelerometer_resource_real_suspendResource_co (_data_);
}


static void hardware_accelerometer_resource_real_suspendResource_finish (FsoFrameworkAbstractDBusResource* base, GAsyncResult* _res_) {
	hardware_accelerometer_resource_suspendResourceData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean hardware_accelerometer_resource_real_suspendResource_co (hardware_accelerometer_resource_suspendResourceData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
	fso_framework_logger_debug (_data_->_tmp0_, "suspending...");
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void hardware_accelerometer_resource_real_resumeResource_data_free (gpointer _data) {
	hardware_accelerometer_resource_resumeResourceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (hardware_accelerometer_resource_resumeResourceData, _data_);
}


static void hardware_accelerometer_resource_real_resumeResource (FsoFrameworkAbstractDBusResource* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	HardwareAccelerometerResource * self;
	hardware_accelerometer_resource_resumeResourceData* _data_;
	HardwareAccelerometerResource* _tmp0_;
	self = (HardwareAccelerometerResource*) base;
	_data_ = g_slice_new0 (hardware_accelerometer_resource_resumeResourceData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, hardware_accelerometer_resource_real_resumeResource);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, hardware_accelerometer_resource_real_resumeResource_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	hardware_accelerometer_resource_real_resumeResource_co (_data_);
}


static void hardware_accelerometer_resource_real_resumeResource_finish (FsoFrameworkAbstractDBusResource* base, GAsyncResult* _res_) {
	hardware_accelerometer_resource_resumeResourceData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean hardware_accelerometer_resource_real_resumeResource_co (hardware_accelerometer_resource_resumeResourceData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
	fso_framework_logger_debug (_data_->_tmp0_, "resuming...");
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void hardware_accelerometer_resource_class_init (HardwareAccelerometerResourceClass * klass) {
	hardware_accelerometer_resource_parent_class = g_type_class_peek_parent (klass);
	FSO_FRAMEWORK_ABSTRACT_DBUS_RESOURCE_CLASS (klass)->enableResource = hardware_accelerometer_resource_real_enableResource;
	FSO_FRAMEWORK_ABSTRACT_DBUS_RESOURCE_CLASS (klass)->enableResource_finish = hardware_accelerometer_resource_real_enableResource_finish;
	FSO_FRAMEWORK_ABSTRACT_DBUS_RESOURCE_CLASS (klass)->disableResource = hardware_accelerometer_resource_real_disableResource;
	FSO_FRAMEWORK_ABSTRACT_DBUS_RESOURCE_CLASS (klass)->disableResource_finish = hardware_accelerometer_resource_real_disableResource_finish;
	FSO_FRAMEWORK_ABSTRACT_DBUS_RESOURCE_CLASS (klass)->suspendResource = hardware_accelerometer_resource_real_suspendResource;
	FSO_FRAMEWORK_ABSTRACT_DBUS_RESOURCE_CLASS (klass)->suspendResource_finish = hardware_accelerometer_resource_real_suspendResource_finish;
	FSO_FRAMEWORK_ABSTRACT_DBUS_RESOURCE_CLASS (klass)->resumeResource = hardware_accelerometer_resource_real_resumeResource;
	FSO_FRAMEWORK_ABSTRACT_DBUS_RESOURCE_CLASS (klass)->resumeResource_finish = hardware_accelerometer_resource_real_resumeResource_finish;
	G_OBJECT_CLASS (klass)->finalize = hardware_accelerometer_resource_finalize;
}


static void hardware_accelerometer_resource_instance_init (HardwareAccelerometerResource * self) {
}


static void hardware_accelerometer_resource_finalize (GObject* obj) {
	HardwareAccelerometerResource * self;
	self = HARDWARE_ACCELEROMETER_RESOURCE (obj);
	G_OBJECT_CLASS (hardware_accelerometer_resource_parent_class)->finalize (obj);
}


/**
 * Implementation of org.freesmartphone.Resource for the Accelerometer Resource
 **/
GType hardware_accelerometer_resource_get_type (void) {
	return hardware_accelerometer_resource_type_id;
}


GType hardware_accelerometer_resource_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (HardwareAccelerometerResourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) hardware_accelerometer_resource_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (HardwareAccelerometerResource), 0, (GInstanceInitFunc) hardware_accelerometer_resource_instance_init, NULL };
	hardware_accelerometer_resource_type_id = g_type_module_register_type (module, FSO_FRAMEWORK_TYPE_ABSTRACT_DBUS_RESOURCE, "HardwareAccelerometerResource", &g_define_type_info, 0);
	return hardware_accelerometer_resource_type_id;
}


/**
 * This function gets called on plugin initialization time.
 * @return the name of your plugin here
 * @note that it needs to be a name in the format <subsystem>.<plugin>
 * else your module will be unloaded immediately.
 **/
gchar* fso_factory_function (FsoFrameworkSubsystem* subsystem, GError** error) {
	gchar* result = NULL;
	FsoFrameworkSubsystem* _tmp0_;
	HardwareAccelerometer* _tmp1_;
	FsoFrameworkSubsystem* _tmp2_;
	HardwareAccelerometerResource* _tmp3_;
	gchar* _tmp4_;
	g_return_val_if_fail (subsystem != NULL, NULL);
	_tmp0_ = subsystem;
	_tmp1_ = hardware_accelerometer_new (_tmp0_);
	_g_object_unref0 (instance);
	instance = _tmp1_;
	_tmp2_ = subsystem;
	_tmp3_ = hardware_accelerometer_resource_new (_tmp2_);
	_g_object_unref0 (accelerometer);
	accelerometer = _tmp3_;
	_tmp4_ = g_strdup (HARDWARE_HW_ACCEL_PLUGIN_NAME);
	result = _tmp4_;
	return result;
}


void fso_register_function (GTypeModule* module) {
	FsoFrameworkLogger* _tmp0_;
	g_return_if_fail (module != NULL);
	hardware_accelerometer_register_type (module);
	hardware_accelerometer_resource_register_type (module);
	_tmp0_ = fso_framework_theLogger;
	fso_framework_logger_debug (_tmp0_, "fsodevice.accelerometer fso_register_function()");
}



