# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
# Copyright 2013 Canonical
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.


class FriendsAppUtils(object):
    """An emulator class that makes it easy to interact with
    general components of the friends-app app.
    """

    def __init__(self, app):
        self.app = app

    def get_main_view(self):
        """Get the main QML view"""
        return self.app.select_single("MainView", objectName="main")

    def get_post_view(self):
        """Get the post QML view"""
        return self.app.select_single("Post", objectName="post")

    def get_stream_model(self):
        """Get the StreamModel"""
        return self.app.select_single("StreamModel", objectName="streamModel")

    def get_toolbar(self):
        """Returns the toolbar in the main events view."""
        main_view = self.get_main_view()
        return main_view.select_single("Toolbar")

    def get_qml_view(self):
        """Get the main QML view"""
        return self.app.select_single("QQuickView")
