/*
 * Copyright 2013 Canonical Ltd.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * telephony-app is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick 2.0
import Ubuntu.Components 0.1
import Ubuntu.Unity.Action 1.0 as UnityActions
import Ubuntu.OnlineAccounts 0.1
import Friends 0.2

MainView {
    id: main
    applicationName: "friends-app"
    // objectName for functional testing purposes (autopilot-qt5)
    objectName: "main"
    automaticOrientation: true

    width: units.gu(60)
    height: units.gu(90)

    backgroundColor: "#273d66"
    headerColor: "#395996"

    property bool isPortrait: (height > width)

    Action {
        id: postAction
        text: i18n.tr("Post")
        keywords: "Post;Send"
        iconSource: ("images/new.png")
        onTriggered: pageStack.push(postPage)
    }

    Action {
        id: refreshAction
        text: i18n.tr("Refresh")
        iconSource: ("images/reload.png")
        keywords: "Update;Refresh"
        onTriggered: friends.refresh()
    }

    Action {
        id: topAction
        text: i18n.tr("Top")
        iconSource: ("images/go-top.png")
        onTriggered: timeline.jumpToTop()
    }

    actions: [topAction, refreshAction, postAction]

    AccountServiceModel {
        id: accounts
        serviceType: "microblogging"
    }

    FriendsDispatcher {
        id: friends
    }

    PageStack {
        id: pageStack
        Component.onCompleted: {
            console.log ("accounts.count: "+accounts.count);
            pageStack.push(timeline);
            if (accounts.count < 1)
                pageStack.push(noAccountsPage);
        }

        Page {
            id: noAccountsPage
            title: i18n.tr("Setup Accounts")
            Setup {
                id: noAccounts
                anchors {
                    fill: parent
                }
            }
            visible: false
            tools: ToolbarItems {
            }
        }

        Page {
            id: postPage
            title: i18n.tr("Share with your friends")
            Post {
                id: post
                anchors {
                    fill: parent
                }
            }
            visible: false
            tools: ToolbarItems {
            }
        }

        TimeLine {
            id: timeline

            visible: false
            tools: ToolbarItems {
                ToolbarButton {
                    action: topAction
                }
                ToolbarButton {
                    action: refreshAction
                }
                ToolbarButton {
                    action: postAction
                }
            }
        }
    }
}
