#!/bin/bash
# Gnu-Gettext Version needs to be reasonably new.
gettext_ver=`gettextize --version | head -1 | sed -e 's/[^ ]* //g' -e 's/\.//g'`

if test $gettext_ver -lt 0130; then
    echo " Don't use gettext older than 0.13.0 " 2>&1
    exit 1
fi
# further process.
grep -v 'read.*/dev/tty' $(which gettextize) > gettextize.fixed
chmod +x ./gettextize.fixed
./gettextize.fixed  --no-changelog
rm -f *~ gettextize.fixed
aclocal
autoconf
automake --add-missing

echo "Now run ./configure and make"