.TH FOTOXX 1 2014-06-01 "Linux" "Fotoxx man page"

.SH NAME
 Fotoxx - photo/image editor and collection manager

.SH SYNOPSIS
 \fBFotoxx\fR [ \fBoptions\fR ] [ \fIfile\fR | \fIdirectory\fR ]

.SH DESCRIPTION
 Fotoxx is a GUI program which operates in its own window. 
 Organize and administer a collection of images, edit images, 
 search images, and perform utility functions.

.SH OVERVIEW

Image edit functions include:
 - View and edit most image file types and RAW file types
 - Adjust brightness/color/contrast using movable curves
 - Expand and/or flatten the brightness distribution
 - Trim (crop), Resize, Flip, Rotate (any angle)
 - Sharpen, Blur, Reduce noise, Remove red-eyes
 - Tone Mapping (enhance local contrast and faint details)
 - Auto adjust white balance, Match colors to a standard
 - Remove a color caste even if it varies across the image
 - Fix vignetting and other brightness uniformity problems
 - Warp (stretch/distort image by dragging the mouse)
 - Panorama, HDR and Stack composites (tripod not needed)
 - Combine photos of a subject with differing focus depths (HDF)
 - Art effects (drawing, painting, cartoon, 3D relief, mosaic)
 - Edit and apply custom convolution kernels
 - Pixel edit with variable brush transparency and blending
 - Paint retouch functions gradually with the mouse
 - Smart erase: get rid of ground litter, power lines, etc.
 - Erase dust: remove dust spots on images from scanned slides
 - Flatten photo of curved book page, stretch compressed text
 - Edit selected objects or areas separately within an image
 - Copy and paste selected objects or areas across images
 - Write text on an image (font/color/transparency/shadow/angle)
 - Montage: Arrange images and formatted text in a layout
 - Use Gimp, ImageMagick, etc. as plug-in functions

Utility functions include:
 - Context aware help available via the F1 key
 - Thumbnail browser and navigator, click image to view/edit
 - Custom graphic menu with user-selected content and layout
 - Assign custom keyboard shortcuts to menu functions
 - Bookmark image locations, jump to bookmarked location
 - Use geotags from camera GPS, add/edit geotags manually
 - Edit any image metadata (EXIF/IPTC tags, dates, comments...)
 - Convert image color profile (e.g. sRGB <-> Adobe RGB)
 - Search and report any metadata, thumbnail and text report
 - Search images by location, show in thumbnail gallery
 - Batch convert format, resize, move, burn CD/DVD/BlueRay
 - Batch rename images using a base name and sequence number
 - Batch convert RAW files to tiff-8/16, png-8/16 or jpeg
 - Print image using any paper format, make color adjustments
 - Create named image collections (select and arrange images)
 - Slide-show: auto or keyboard control, animated transitions
 - Monitor color and gamma test patterns

.SH OPTIONS
Command line options
 \fB-v\fR                print version and exit
 \fB-lang\fR \fIcode\fR        specify language (de, fr ...)
 \fB-prev\fR             open last file from the previous session
 \fB-recent\fR           show a gallery of most recent files 
 \fIfile\fR              initial image file to view or edit
 \fIdirectory\fR         initial directory for gallery of images

.SH SEE ALSO
 The online user manual is available using the help menu.
 This manual explains Fotoxx operation in great detail.
 The home page for Fotoxx is http://kornelix.com/fotoxx.

.SH AUTHORS
 Written by Mike Cornelison <kornelix@posteo.de>
 http://kornelix.com

