/* $Header: /home/yav/catty/fkiss/RCS/selcnf.c,v 1.26 2000/09/28 07:53:44 yav Exp $
 * fkiss config selecter
 * written by yav <yav@bigfoot.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>
#include "config.h"
#include "headers.h"
#include "fkiss.h"
#include "work.h"
#define PUBLIC_SELCNF_C
#include "extern.h"

#if HAVE_SYS_STAT_H
# include <sys/stat.h>
#else
# if HAVE_STAT_H
#  include <stat.h>
# endif
#endif

#define BASE_MARGIN 2
#define BASE_TOP_MARGIN		BASE_MARGIN
#define BASE_BOTTOM_MARGIN	BASE_MARGIN
#define BASE_LEFT_MARGIN	BASE_MARGIN
#define BASE_RIGHT_MARGIN	BASE_MARGIN

#define MENU_TOP_MARGIN		2
#define MENU_BOTTOM_MARGIN	3
#define MENU_LEFT_MARGIN	4
#define MENU_RIGHT_MARGIN	4

char id_selcnf[] = "$Id: selcnf.c,v 1.26 2000/09/28 07:53:44 yav Exp $";
static Window selwin;
static int menuw = 128;
static int menuh = MENU_TOP_MARGIN+11+2+MENU_BOTTOM_MARGIN;
static char **conflist = NULL;
static char *str_cancel = "(Cancel)";
static MW *mwsel;
static char default_cnf_suffix[] = ".cnf";
static char current_dir[] = ".";

int is_regular_file(str)
     char *str;
{
  struct stat st;
  
  return stat(str, &st) == 0 && (st.st_mode & S_IFMT) == S_IFREG;
}

int match_cnf(char *p)
{
  return is_suffix(p, default_cnf_suffix);
}

char **find_cnf_file(path)
     char *path;
{
  debug_printf("find_cnf_file ``%s''\n", path);
  return dir_ls(path, match_cnf);
}

void set_menu_font(list)
     char **list;		/* menu string list */
{
  int i, maxwidth;
  
  if (fsp == NULL)
    return;
  maxwidth = calc_text_size(str_cancel);
  for (; *list != NULL; list++) {
    i = calc_text_size(*list);
    if (i > maxwidth)
      maxwidth = i;
  }
  menuh = MENU_TOP_MARGIN + font_ascent + font_descent + MENU_BOTTOM_MARGIN;
  menuw = MENU_LEFT_MARGIN + maxwidth + MENU_RIGHT_MARGIN;
  debug_printf("font: %s\nfont ascent %d, descent %d\n",
	       str_font, font_ascent, font_descent);
}

int which_menuwin(win)
     Window win;
{
  return which_winlist(win, mwsel);
}

void set_menu_status(n, mode)
     int n;
     int mode;
{
  change_menu_status((mwsel+n)->win, (mwsel+n)->st = mode);
}

int select_menu(title, geomstr, mlist)
     char *title;		/* window title */
     char *geomstr;		/* window geometry string */
     char **mlist;		/* menu string list */
{
  int i, r;
  int menucnt;
  int x, y, w, h, f;
  XSizeHints hint;
  XEvent ev;
  Bool fin;
  unsigned long atrmask;
  XSetWindowAttributes atr;
  
  set_menu_font(mlist);
  for (menucnt = 0; *(mlist+menucnt) != NULL; menucnt++)
    ;
  menucnt++;				/* append "Cancel" menu */
  hint.flags = PSize;
  x = y = 0;
  atr.save_under = True;
  atrmask = CWSaveUnder;
  if (geomstr != NULL && geomstr[0]) {
    /* window geometry is specified */
    f = XGeometry(dsp, scr, geomstr, "", 1, 1, 1, 0, 0, &x, &y, &w, &h);
    if (f & XValue)
      hint.flags |= USPosition;
    if (f & YValue)
      hint.flags |= USPosition;
    atr.override_redirect = True;
    atrmask |= CWOverrideRedirect;
  }
  
  w = menuw+BASE_LEFT_MARGIN+BASE_RIGHT_MARGIN;
  h = menuh*menucnt+BASE_TOP_MARGIN+BASE_BOTTOM_MARGIN;
  hint.x = x;
  hint.y = y;
  hint.width = w;
  hint.height = h;
  selwin = XCreateSimpleWindow(dsp, rootwin, x, y, w, h,
			       1, spx[SPX_FG], spx[SPX_BG]);
  XSetStandardProperties(dsp, selwin, title, title, 0,
			 oargv, oargc, &hint);
  XSelectInput(dsp, selwin, ExposureMask);
  XChangeWindowAttributes(dsp, selwin, atrmask, &atr);
  
  mwsel = alloc_mw(menucnt);
  for (i = 0; i < menucnt; i++) {
    (mwsel+i)->win =
      XCreateSimpleWindow(dsp, selwin,
			  BASE_LEFT_MARGIN, BASE_TOP_MARGIN+i*menuh,
			  menuw, menuh,
			  0, spx[SPX_FG], spx[SPX_BT]);
    XSelectInput(dsp, (mwsel+i)->win, ExposureMask|
		 ButtonPressMask|ButtonReleaseMask|OwnerGrabButtonMask|
		 EnterWindowMask|LeaveWindowMask);
  }
  cursor_set(selwin, 3);	/* 3: CUR_ARROW */
  XMapRaised(dsp, selwin);
  XMapSubwindows(dsp, selwin);
  r = -1;
  fin = False;
  while (!fin) {
    XNextEvent(dsp, &ev);
    switch(ev.type) {
    case Expose:
      if (!ev.xexpose.count) {
	i = which_menuwin(ev.xexpose.window);
	if (i >= 0) {
	  draw_menu_string((mwsel+i)->win, (mwsel+i)->st, menuw, menuh,
			   MENU_LEFT_MARGIN, MENU_TOP_MARGIN,
			   (i == menucnt-1)?str_cancel:*(mlist+i));
#if 0
	  if ((mwsel+i)->st & 2)
	    fin = True;
#endif
	}
      }
      break;
    case EnterNotify:
    case LeaveNotify:
      i = which_menuwin(ev.xcrossing.window);
      if (i >= 0)
	set_menu_status(i, (ev.type == EnterNotify));
      break;
      /* case ButtonPress: */
    case ButtonRelease:
      i = (ev.xbutton.button == Button1) ?
	which_menuwin(ev.xbutton.window) : menucnt-1;
      if (i >= 0) {
	r = (i == menucnt-1) ? -1 : i; /* -1 for Cancel */
	set_menu_status(i, 2);
	fin = True;
      }
      break;
    }
  }
  XDestroyWindow(dsp, selwin);
  XFlush(dsp);
  free(mwsel);
  return r;
}

int cnf_exist_check(name)
     char *name;
{
  int i;
  
  conf_file = ks_strdup(name);
  i = is_regular_file(conf_file);
  if (!i && extract_dir != NULL) {
    conf_file = ks_realloc(strlen(extract_dir) + 1 + strlen(name) + 1);
    sprintf(conf_file, "%s/%s", extract_dir, name);
    i = is_regular_file(conf_file);
  }
  return i;
}

/*
 * input:
 *	name		config file
 *	extract_dir	LHa extracted directory
 * output:
 *	conf_dir[]	cell and kcf file base directory
 *	conf_file[]	configuration file
 */
int select_cnf(name)
     char *name;
{
  int i, r;
  char *p;
  LSTR buf;

  conf_dir = NULL;
  conf_file = NULL;
  lstr_init(&buf);
  if (name != NULL) {
    i = cnf_exist_check(name);
    if (!i) {
      lstr_cat(&buf, name);
      lstr_cat(&buf, default_cnf_suffix);
      i = cnf_exist_check(buf.buf);
    }
    if (i) {
      conf_dir = get_directory(conf_file);
      if (!*conf_dir) {
	free(conf_dir);
	conf_dir = ks_strdup(current_dir);
      }
      return 0;
    }
    /* name will be directory */
    conf_dir = ks_strdup(name);
  }
  if (extract_dir != NULL) {
    if (conf_dir != NULL)
      free(conf_dir);
    conf_dir = ks_strdup(extract_dir);
  }
  if (conf_dir == NULL || !conf_dir[0]) {
    if (conf_dir != NULL)
      free(conf_dir);
    conf_dir = ks_strdup(current_dir);
  }
  conflist = find_cnf_file(conf_dir);
  if (conflist == NULL) {
    msg("W ``%s'' open error!\n", conf_dir);
    r = -2;
  } else if (*conflist == NULL) {
    r = -2;			/* No *.cnf */
  } else if (*(conflist+1) == NULL) {
    r = 0;			/* One *.cnf */
  } else {
    r = select_menu("fkiss sel", str_geometry, conflist);
  }
  if (r >= 0) {
    if (conf_file != NULL)
      free(conf_file);
    conf_file = ks_malloc(strlen(conf_dir) + 1 + strlen(*(conflist+r)) + 1);
    sprintf(conf_file, "%s/%s", conf_dir, *(conflist+r));
    
    free(conf_dir);
    conf_dir = ks_strdup(conf_file);
    p = rindex(conf_dir, '/');
    if (p)
      *p = '\0';

  }
  if (conflist != NULL)
    dir_free(conflist);
  debug_printf("selconf conf_dir [%s]\n", conf_dir);
  return r;
}

/* End of file */
