#! /bin/sh
#
# /etc/init.d/firewall-easy: start packet filter firewall
#

PATH=/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin
FIREWALL=/usr/sbin/firewall-easy
NAME=firewall
DESC=firewall

test -f $FIREWALL || exit 0

set -e

case "$1" in
  start)
	echo -n "Setting up $DESC: ... "
	$FIREWALL start
	echo "$NAME."
	;;
  stop)
	echo -n "Stopping $DESC: "
	$FIREWALL list > /var/log/firewall-list.laststop
	$FIREWALL stop
	echo "$NAME."
	;;
  reload|force-reload)
	echo -n "Restarting $DESC: "
	$FIREWALL reload
	echo "$NAME."
	;;
  restart)
	echo -n "Restarting $DESC: "
	$FIREWALL restart
	echo "$NAME."
	;;
  *)
	N=/etc/init.d/$NAME
	echo "Usage: $N {start|stop|restart|reload|force-reload}" >&2
	exit 1
	;;
esac

exit 0
