const CONTEXTUALACTION_PREFIX = "contextualAction";

function thumbnailPrefInit() {
  // Check all enable/disable dependancies
  thumbnailShowLabelsChanged();
  thumbnailAnimationChanged();
  paintAfterLoadedChanged();
  updateThumbnailWhenContentChangesChanged();
}

function contextualActionsChanged(el) {
  if (el.attrName == "value") {
    document.getElementById("paneThumbnails").userChangedValue(document.getElementById("contextualActions"));
  }
}

function thumbnailShowLabelsChanged() {
  var thumbnailShowLabelsCheckbox = document.getElementById("thumbnailShowLabels");
  document.getElementById("thumbnailLabelStyleLabel").disabled = !thumbnailShowLabelsCheckbox .checked;
  document.getElementById("thumbnailLabelStyleAction").disabled = !thumbnailShowLabelsCheckbox .checked;
}

function thumbnailAnimationChanged() {
  var thumbnailAnimationCheckbox = document.getElementById("thumbnailAnimation");
  document.getElementById("thumbnailActiveSizeLabel").disabled = !thumbnailAnimationCheckbox.checked;
  document.getElementById("thumbnailActiveSizeSymbolLabel").disabled = !thumbnailAnimationCheckbox.checked;
  document.getElementById("thumbnailActiveSize").disabled = !thumbnailAnimationCheckbox.checked;
  document.getElementById("animationFramesLabel").disabled = !thumbnailAnimationCheckbox.checked;
  document.getElementById("animationFrames").disabled = !thumbnailAnimationCheckbox.checked;
}

function paintAfterLoadedChanged() {
  var paintThumbnailsAfterLoadingCheckbox = document.getElementById("paintThumbnailsAfterLoading");
  document.getElementById("paintSelectedTabsFirst").disabled = !paintThumbnailsAfterLoadingCheckbox.checked;
}

function updateThumbnailWhenContentChangesChanged() {
  var updateThumbnailWhenContentChangesCheckbox = document.getElementById("updateThumbnailWhenContentChanges");
  document.getElementById("limitContentChangeUpdates").disabled = !updateThumbnailWhenContentChangesCheckbox.checked;
  document.getElementById("limitContentChangeUpdatesTime").disabled = !updateThumbnailWhenContentChangesCheckbox.checked;
  document.getElementById("contentUpdatesMillisecondsLabel").disabled = !updateThumbnailWhenContentChangesCheckbox.checked;
}