/*
 *  $Id: video_fau_camera_gui_gtk.c,v 1.11 2010-12-10 09:06:10 vrsieh Exp $
 *
 * Copyright (C) 2010 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */


#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include <gtk/gtk.h>

#include "glue-gui-gtk.h"
#include "glue-gui-gtk-change.h"

#include "video_fau_camera_gui_gtk.h"

#define COMP "video_fau_camera"

struct cpssp {
	GtkWidget *gui_change;

	struct sig_opt_rgb *port_optical;
	struct sig_string *port_image;
};


/*
 * Simulator Callbacks
 */
static void
video_fau_camera_gui_gtk_image_set(void *_cpssp, const char *str)
{
	struct cpssp *cpssp = _cpssp;

	gui_gtk_change_set(GUI_GTK_CHANGE(cpssp->gui_change), str);
}

static void
video_fau_camera_gui_gtk_movie_set(void *_cpssp, const char *str)
{
	/* FIXME */
}

/*
 * GUI Callbacks
 */
static void
video_fau_camera_gui_gtk_show_event(
	GtkWidget *w,
	const char *string,
	gpointer _cpssp
)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	sig_string_set(cpssp->port_image, cpssp, string);
}

static void
video_fau_camera_gui_gtk_hide_event(
	GtkWidget *w,
	gpointer _cpssp
)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	sig_string_set(cpssp->port_image, cpssp, "");
}

void *
video_fau_camera_gui_gtk_create(
	unsigned int page,
	const char *name,
	struct sig_manage *port_manage,
	struct sig_boolean *port_power,
	struct sig_opt_rgb *port_optical,
	struct sig_video *port_video,
	struct sig_string *port_image,
	struct sig_string *port_movie
)
{
	static const struct sig_string_funcs image_funcs = {
		.set = video_fau_camera_gui_gtk_image_set,
	};
	static const struct sig_string_funcs movie_funcs = {
		.set = video_fau_camera_gui_gtk_movie_set,
	};
	struct cpssp *cpssp;
	GtkWidget *vbox;

	cpssp = malloc(sizeof(*cpssp));
	assert(cpssp);

	vbox = gtk_vbox_new(FALSE, 1);

	/* Change Dialog */
	cpssp->gui_change = gui_gtk_change_new("Camera");
	GTK_WIDGET_UNSET_FLAGS(cpssp->gui_change, GTK_CAN_FOCUS);
	g_signal_connect(G_OBJECT(cpssp->gui_change), "change-inserted",
			G_CALLBACK(video_fau_camera_gui_gtk_show_event), cpssp);
	g_signal_connect(G_OBJECT(cpssp->gui_change), "change-removed",
			G_CALLBACK(video_fau_camera_gui_gtk_hide_event), cpssp);
	gtk_widget_show(cpssp->gui_change);
	gtk_box_pack_end(GTK_BOX(vbox), cpssp->gui_change, FALSE, FALSE, 1);

	gtk_widget_show(vbox);
	gui_gtk_comp_add(page, COMP, name, vbox, FALSE, FALSE, NULL);

	/* Call */

	/* Out */
	cpssp->port_optical = port_optical;
	cpssp->port_image = port_image;

	/* In */
	sig_string_connect(port_image, cpssp, &image_funcs);
	sig_string_connect(port_movie, cpssp, &movie_funcs);

	return cpssp;
}

void
video_fau_camera_gui_gtk_destroy(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	free(cpssp);
}
