/*
 * $Id: mb_ibm_at_ram_rom_decode.c,v 1.8 2009-06-03 11:34:09 vrsieh Exp $ 
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include "mb_ibm_at_ram_rom_decode.h"

struct cpssp {
	struct sig_cs *port_ram_cs[4];
	struct sig_cs *port_rom_cs[4];
	struct sig_isa_bus_main *port_bus_low;
	struct sig_isa_bus_main *port_bus_high;
};

static int
mb_ibm_at_ram_rom_decode_readb(
	void *_cpssp,
	uint32_t addr,
	uint8_t *valp
)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	if (addr < 0x40000) {
		return sig_cs_readb(cpssp->port_ram_cs[0 + (addr & 1)], cpssp,
				valp, (addr >> 1) & 0x1ffff);
	} else if (addr < 0x80000) {
		return sig_cs_readb(cpssp->port_ram_cs[2 + (addr & 1)], cpssp,
				valp, (addr >> 1) & 0x1ffff);
	} else if (addr < 0xe0000) {
		return -1;
	} else if (addr < 0xf0000) {
		return sig_cs_readb(cpssp->port_rom_cs[0 + (addr & 1)], cpssp,
				valp, (addr >> 1) & 0x7fff);
	} else if (addr < 0x100000) {
		return sig_cs_readb(cpssp->port_rom_cs[2 + (addr & 1)], cpssp,
				valp, (addr >> 1) & 0x7fff);
	} else {
		return -1;
	}
}

static int
mb_ibm_at_ram_rom_decode_writeb(
	void *_cpssp,
	uint32_t addr,
	uint8_t val
)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	if (addr < 0x40000) {
		return sig_cs_writeb(cpssp->port_ram_cs[0 + (addr & 1)], cpssp,
				val, (addr >> 1) & 0x1ffff);
	} else if (addr < 0x80000) {
		return sig_cs_writeb(cpssp->port_ram_cs[2 + (addr & 1)], cpssp,
				val, (addr >> 1) & 0x1ffff);
	} else if (addr < 0xe0000) {
		return -1;
	} else if (addr < 0xf0000) {
		return sig_cs_writeb(cpssp->port_rom_cs[0 + (addr & 1)], cpssp,
				val, (addr >> 1) & 0x7fff);
	} else if (addr < 0x100000) {
		return sig_cs_writeb(cpssp->port_rom_cs[2 + (addr & 1)], cpssp,
				val, (addr >> 1) & 0x7fff);
	} else {
		return -1;
	}
}

static int
mb_ibm_at_ram_rom_decode_readw(
	void *cpssp,
	uint32_t addr,
	uint16_t *valp
)
{
	uint8_t val0;
	uint8_t val1;
	int ret;

	ret = mb_ibm_at_ram_rom_decode_readb(cpssp, addr + 0, &val0)
	    | mb_ibm_at_ram_rom_decode_readb(cpssp, addr + 1, &val1);

	*valp = (val0 << 0) | (val1 << 8);

	return ret;
}

static int
mb_ibm_at_ram_rom_decode_writew(
	void *cpssp,
	uint32_t addr,
	uint16_t val
)
{
	uint8_t val0;
	uint8_t val1;
	int ret;

	val0 = val >> 0;
	val1 = val >> 8;

	ret = mb_ibm_at_ram_rom_decode_writeb(cpssp, addr + 0, val0)
	    | mb_ibm_at_ram_rom_decode_writeb(cpssp, addr + 1, val1);

	return ret;
}

void *
mb_ibm_at_ram_rom_decode_create(
	const char *name,
	struct sig_manage *port_manage,
	struct sig_isa_bus_main *port_bus,
	struct sig_cs *port_ram0_cs,
	struct sig_cs *port_ram1_cs,
	struct sig_cs *port_ram2_cs,
	struct sig_cs *port_ram3_cs,
	struct sig_cs *port_rom0_cs,
	struct sig_cs *port_rom1_cs,
	struct sig_cs *port_rom2_cs,
	struct sig_cs *port_rom3_cs,
	struct sig_isa_bus_main *port_bus_low,
	struct sig_isa_bus_main *port_bus_high
)
{
	static const struct sig_isa_bus_main_funcs bus_funcs = {
		.readb = mb_ibm_at_ram_rom_decode_readb,
		.readw = mb_ibm_at_ram_rom_decode_readw,
		.writeb = mb_ibm_at_ram_rom_decode_writeb,
		.writew = mb_ibm_at_ram_rom_decode_writew,
	};
	struct cpssp *cpssp;

	cpssp = malloc(sizeof(*cpssp));
	assert(cpssp);

	cpssp->port_ram_cs[0] = port_ram0_cs;
	cpssp->port_ram_cs[1] = port_ram1_cs;
	cpssp->port_ram_cs[2] = port_ram2_cs;
	cpssp->port_ram_cs[3] = port_ram3_cs;
	cpssp->port_rom_cs[0] = port_rom0_cs;
	cpssp->port_rom_cs[1] = port_rom1_cs;
	cpssp->port_rom_cs[2] = port_rom2_cs;
	cpssp->port_rom_cs[3] = port_rom3_cs;

	cpssp->port_bus_low = port_bus_low;
	cpssp->port_bus_high = port_bus_high;

	sig_isa_bus_main_connect(port_bus, cpssp, &bus_funcs);

	return cpssp;
}

void
mb_ibm_at_ram_rom_decode_destroy(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	free(cpssp);
}
