/*
 * $Id: floppy_gen_floppydrive_gui.c,v 1.12 2009-10-15 13:54:56 vrsieh Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>

#include "config.h"

#include "glue-gui.h"

#include "floppy_gen_floppydrive_gui.h"

#ifdef HAVE_GTK
#include "floppy_gen_floppydrive_gui_gtk.h"
#endif

void *
floppy_gen_floppydrive_gui_create(
	unsigned int page,
	const char *name,
	const char *model,
	const char *unit,
	struct sig_manage *port_manage,
	struct sig_power_device *port_power,
	struct sig_shugart_bus *port_shugart,
	struct sig_boolean *port_opt_busy_led,
	struct sig_floppy *port_media,
	struct sig_string *port_change
)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		return floppy_gen_floppydrive_gui_gtk_create(
				page,
				name,
				model,
				unit,
				port_manage,
				port_power,
				port_shugart,
				port_opt_busy_led,
				port_media,
				port_change);
		break;
#endif
	case GUI_NULL:
		return (void *) 1;
	default:
		assert(0);
	}
}

void
floppy_gen_floppydrive_gui_destroy(void *_cpssp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		floppy_gen_floppydrive_gui_gtk_destroy(_cpssp);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}
