/*
 * $Id: conn_ps2.c,v 1.5 2009-06-03 11:34:05 vrsieh Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include "conn_ps2.h"

struct cpssp {
	struct sig_boolean_merge *forward_power;
	struct sig_ps2_main_merge *forward_main;
};

void *
conn_ps2_create(
	const char *name,
	struct sig_manage *port_manage,
	struct sig_ps2 *port_female,
	struct sig_boolean *port__plus_5V,
	struct sig_ps2_main *port_board
)
{
	struct cpssp *cpssp;

	cpssp = malloc(sizeof(*cpssp));
	assert(cpssp);

	cpssp->forward_main = sig_ps2_main_merge(port_female->main, port_board);
	cpssp->forward_power = sig_boolean_merge(port_female->p5V, port__plus_5V);

	return cpssp;
}

void
conn_ps2_destroy(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	free(cpssp);
}
