/* $Id: arch_gen_cpu_x86_kernel_fast.h,v 1.3 2009-01-28 13:57:48 potyra Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __KFAUM_H_INCLUDED
#define __KFAUM_H_INCLUDED

#define USE_KFAUM	0

#if USE_KFAUM

extern int NAME_(kfaum_enabled);

static inline int
kfaum_is_ok(struct CPUState *s)
{
	return NAME_(kfaum_enabled)
	    && (s->hflags & HF_CPL_MASK) == 3
	    && (s->eflags & CPU_IOPL_MASK) != CPU_IOPL_MASK
	    && (s->cr[0] & CPU_CR0_PE_MASK)
	    && (s->eflags & CPU_IF_MASK)
	    && ! (s->eflags & CPU_VM_MASK);
}

extern int
NAME_(kfaum_init)(void);

extern int
NAME_(kfaum_protect_page)(uint64_t pa);
extern int
NAME_(kfaum_flush_page)(unsigned long page);
extern int
NAME_(kfaum_flush_all)(int global);

extern int
NAME_(kfaum_exec)(struct CPUState *s);

#endif /* USE_KFAUM */

#endif /* __KFAUM_H_INCLUDED */
