/*
 * $Id: sig_host_bus.h,v 1.31 2009-11-13 08:30:34 vrsieh Exp $
 *
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SIG_HOST_BUS_H_INCLUDED
#define __SIG_HOST_BUS_H_INCLUDED

#include <inttypes.h>

/* Should be configurable! FIXME VOSSI */
#define SIG_HOST_BUS_HZ     (60*1000*1000)

#include "sig_boolean.h"
#include "sig_boolean_or.h"
#include "sig_icc_bus.h"
#include "sig_gen.h"

enum sig_host_bus_main_cycle {
	/* Must be the same as in sig_pci_bus.h! */
	SIG_HOST_BUS_C0R = 0,
	SIG_HOST_BUS_C0W,
	SIG_HOST_BUS_C1R,
	SIG_HOST_BUS_C1W,
	SIG_HOST_BUS_IOR,
	SIG_HOST_BUS_IOW,
	SIG_HOST_BUS_MR,
	SIG_HOST_BUS_MW,
	SIG_HOST_BUS_INTA,
};

struct sig_host_bus_main_funcs {
	/* Slave functions. */
	int (*type_addr)(void *s, unsigned int type, uint32_t port);
	int (*read_data)(void *s, unsigned int bs, uint32_t *valp);
	int (*write_data)(void *s, unsigned int bs, uint32_t val);

	int (*ior)(void *s, uint32_t port, unsigned int bs, uint32_t *valp);
	int (*iow)(void *s, uint32_t port, unsigned int bs, uint32_t val);

	int (*ior_info)(void *s, uint32_t port, unsigned int bs,
			int (**cf)(void *, uint32_t, unsigned int, uint32_t *),
			void **cs);
	int (*iow_info)(void *s, uint32_t port, unsigned int bs,
			int (**cf)(void *, uint32_t, unsigned int, uint32_t),
			void **cs);

	void (*ior_info_flush)(void *s, uint32_t port, unsigned int bs);
	void (*iow_info_flush)(void *s, uint32_t port, unsigned int bs);

	int (*mr)(void *s, unsigned int state, uint32_t addr, unsigned int bs,
			uint32_t *valp);
	int (*mw)(void *s, unsigned int state, uint32_t addr, unsigned int bs,
			uint32_t val);

	int (*map_r_check)(void *s,
		unsigned int state, unsigned long pa);
	int (*map_r)(void *s,
		unsigned int state, unsigned long pa, char **haddr_p);
	int (*map_w_check)(void *s,
		unsigned int state, unsigned long pa);
	int (*map_w)(void *s,
		unsigned int state, unsigned long pa, char **haddr_p);
	int (*map_x_check)(void *s,
		unsigned int state, unsigned long pa);
	int (*map_x)(void *s,
		unsigned int state, unsigned long pa, char **haddr_p);
	void (*unmap)(void *s, unsigned long pa, unsigned long len);

	int (*inta_addr)(void *s);
	int (*inta_data)(void *s, uint8_t *valp);
};

#define SIG_HOST_BUS_HASH_SIZE	(1 << 10)

struct sig_host_bus_main {
	enum sig_gen_type type;
	struct {
		void *s;
		const struct sig_host_bus_main_funcs *f;
	} member[16];
	unsigned int member_count;

	struct sig_host_bus_main_io {
		struct sig_host_bus_main_io *lru_prev;
		struct sig_host_bus_main_io *lru_next;

		struct sig_host_bus_main_io *hash_prev;
		struct sig_host_bus_main_io *hash_next;

		enum {
			SIG_HOST_BUS_TYPE_IOR,
			SIG_HOST_BUS_TYPE_IOW,
		} type;

		uint32_t port;
		unsigned int bs;
		int (*ior)(void *s,
				uint32_t port, unsigned int bs, uint32_t *valp);
		int (*iow)(void *s,
				uint32_t port, unsigned int bs, uint32_t val);
		void *s;
	} io[256 + 256];
	struct sig_host_bus_main_io *io_lru_first;
	struct sig_host_bus_main_io *io_lru_last;
	struct sig_host_bus_main_io *io_hash_first[SIG_HOST_BUS_HASH_SIZE];
	struct sig_host_bus_main_io *io_hash_last[SIG_HOST_BUS_HASH_SIZE];

	struct sig_host_bus_main_map {
		struct sig_host_bus_main_map *lru_prev;
		struct sig_host_bus_main_map *lru_next;

		struct sig_host_bus_main_map *hash_prev;
		struct sig_host_bus_main_map *hash_next;

		enum {
			SIG_HOST_BUS_TYPE_MR,
			SIG_HOST_BUS_TYPE_MW,
			SIG_HOST_BUS_TYPE_MX,
		} type;

		unsigned int state;
		unsigned long addr;
		uint32_t *mr;
		uint32_t *mw;
		uint32_t *mx;
	} map[256 + 256 + 256];
	struct sig_host_bus_main_map *map_lru_first;
	struct sig_host_bus_main_map *map_lru_last;
	struct sig_host_bus_main_map *map_hash_first[SIG_HOST_BUS_HASH_SIZE];
	struct sig_host_bus_main_map *map_hash_last[SIG_HOST_BUS_HASH_SIZE];
};

struct sig_host_bus_main_merge {
	struct sig_host_bus_main *s0;
	struct sig_host_bus_main *s1;
};

extern int
sig_host_bus_type_addr(struct sig_host_bus_main *b, void *s,
		unsigned int type, uint32_t addr);
extern int
sig_host_bus_read_data(struct sig_host_bus_main *b, void *s,
		unsigned int bs, uint32_t *valp);
extern int
sig_host_bus_write_data(struct sig_host_bus_main *b, void *s,
		unsigned int bs, uint32_t val);

extern int
sig_host_bus_ior(struct sig_host_bus_main *b, void *s,
		uint32_t port, unsigned int bs, uint32_t *valp);
extern int
sig_host_bus_iow(struct sig_host_bus_main *b, void *s,
		uint32_t port, unsigned int bs, uint32_t val);

extern int
sig_host_bus_mr(struct sig_host_bus_main *b, void *s,
		unsigned int state, uint32_t addr, unsigned int bs,
		uint32_t *valp);
extern int
sig_host_bus_mw(struct sig_host_bus_main *b, void *s,
		unsigned int state, uint32_t addr, unsigned int bs,
		uint32_t val);
extern int
sig_host_bus_map_r(struct sig_host_bus_main *b, void *s,
		unsigned int state, unsigned long pa, char **haddr_p);
extern int
sig_host_bus_map_r_check(struct sig_host_bus_main *b, void *s,
		unsigned int state, unsigned long pa);
extern int
sig_host_bus_map_w(struct sig_host_bus_main *b, void *s,
		unsigned int state, unsigned long pa, char **haddr_p);
extern int
sig_host_bus_map_w_check(struct sig_host_bus_main *b, void *s,
		unsigned int state, unsigned long pa);
extern int
sig_host_bus_map_x(struct sig_host_bus_main *b, void *s,
		unsigned int state, unsigned long pa, char **haddr_p);
extern int
sig_host_bus_map_x_check(struct sig_host_bus_main *b, void *s,
		unsigned int state, unsigned long pa);

extern int
sig_host_bus_inta_addr(struct sig_host_bus_main *b, void *s);
extern int
sig_host_bus_inta_data(struct sig_host_bus_main *b, void *s,
		uint8_t *valp);

extern void
sig_host_bus_ior_info_flush(struct sig_host_bus_main *b, void *s,
		uint32_t port, unsigned int bs);
extern void
sig_host_bus_iow_info_flush(struct sig_host_bus_main *b, void *s,
		uint32_t port, unsigned int bs);

extern void
sig_host_bus_unmap(struct sig_host_bus_main *b,
		void *s, unsigned long pa, unsigned long len);

extern void
sig_host_bus_main_connect(struct sig_host_bus_main *b,
		void *s, const struct sig_host_bus_main_funcs *f);

extern struct sig_host_bus_main_merge *
sig_host_bus_main_merge(
	struct sig_host_bus_main *s0,
	struct sig_host_bus_main *s1
);
extern void
sig_host_bus_main_split(struct sig_host_bus_main_merge *m);

extern struct sig_host_bus_main *
sig_host_bus_main_create(const char *name);
extern void
sig_host_bus_main_destroy(struct sig_host_bus_main *sig);

struct sig_host_bus {
	enum sig_gen_type type;
	struct sig_boolean *power;
	struct sig_boolean *n_reset;
	struct sig_boolean *n_init;
	struct sig_host_bus_main *main;
	struct sig_boolean_or *lint0;
	struct sig_boolean_or *lint1;
	struct sig_boolean *smi;
	struct sig_boolean *a20;
	struct sig_boolean_or *n_ferr;
	struct sig_boolean *n_ignne;
	struct sig_icc_bus *icc;
};

extern struct sig_host_bus *
sig_host_bus_create(const char *name);
extern void
sig_host_bus_destroy(struct sig_host_bus *sig);

#endif /* __SIG_HOST_BUS_H_INCLUDED */
