/* $Id: sac_scanner.l,v 1.9 2009-03-27 12:39:36 vrsieh Exp $ *
 * vim:tabstop=8:shiftwidth=8:textwidth=72:encoding=utf8:
 * Scanner to evaluate sigs_and_comps.spec.
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

%option noyywrap
%option nounput
%option yylineno
%option case-insensitive
%option noinput

%{
#include "config.h"

#include "sac_parser.h"
#include <stdlib.h>
#include <string.h>
#include <assert.h>

static int
hex_to_int(const char *hex_str)
{
	long int res;
	if (strncmp(hex_str, "0x", 2) != 0) {
		assert(0);
		return -1;
	}

	res = strtol(&hex_str[2], NULL, 16);
	return (int)res;
}

%}

ws	[ \n\t]
alpha	[a-zA-Z_]
idchar	[a-zA-Z_0-9]
strchar {idchar}|[\-:. ]
string	\"{strchar}*\"
posnum	[0-9]+
negnum	-{posnum}
num	{negnum}|{posnum}
id	{alpha}{idchar}*
hexnum	0x([0-9a-fA-F]+)
comment	#([^\n]*)\n

%%
{comment}	{ /* skip comments */ }
{ws}		{ /* skip whitespace */ }
","		{ return t_Comma; }
";"		{ return t_Semicolon; }
":"		{ return t_Colon; }
"{"		{ return t_LeftBracket; }
"}"		{ return t_RightBracket; }
"="		{ return t_Equal; }
signal		{ return t_SIGNAL; }
BUS		{ return t_BUS; }
PRIMITIVE	{ return t_PRIMITIVE; }
component	{ return t_COMPONENT; }
port		{ return t_PORT; }
generics	{ return t_GENERICS; }
simsetup	{ return t_SIMSETUP; }
fault_injection	{ return t_FAULTINJECTION; }
IN		{ return t_IN; }
OUT		{ return t_OUT; }
INOUT		{ return t_INOUT; }
{hexnum}	{ 
		  yylval.integer = hex_to_int(yytext);
		  return t_Integer; }
{id}		{ 
		  yylval.string = strdup(yytext);
		  return t_Identifier; }
{num}		{ 
		   yylval.integer = atoi(yytext);
		   return t_Integer; }
{string}	{ 
		  char *s = strdup(&yytext[1]);
		  s[strlen(s) - 1] = '\0';
		  yylval.string = s;
		  return t_String; 
		}
.		{ 
		  fprintf(stderr, 
			"Line %d: illegal character in stream %c\n",
			yylineno, yytext[0]);
		  return t_Invalid;
		}
