/* $Id: sac_parser.y,v 1.17 2009-04-02 09:02:42 potyra Exp $ *
 * vim:tabstop=8:shiftwidth=8:textwidth=72:encoding=utf8:
 * Parser to evaluate sigs_and_comps.spec.
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

%error-verbose
%defines
%{
	/* header includes */
%}

/* symbols */
%token t_Colon;
%token t_Comma;
%token t_Equal;
%token t_LeftBracket;
%token t_RightBracket;
%token t_Semicolon;
/* token with values */
%token t_Identifier;
%token t_Integer;
%token t_String;
/* keywords */
%token t_BUS;
%token t_COMPONENT;
%token t_FAULTINJECTION;
%token t_GENERICS;
%token t_IN;
%token t_INOUT;
%token t_OUT;
%token t_PORT;
%token t_PRIMITIVE;
%token t_SIGNAL;
%token t_SIMSETUP;
/* meta-tokens */
%token t_Invalid;

%union {
	int integer;
	const char *string;
};

%type <integer>
	t_Integer
	opt_generic_initializer

%type <string>
	t_Identifier
	t_String

%{
#include <stdio.h>
#include <string.h>
#include <assert.h>
	static void yyerror(const char *msg);
	extern int yylex(void);
	extern int yylineno;
%}

%%

%start sigs_and_comps_file;

sigs_and_comps_file:
	{ 
		fprintf(stdout, "PACKAGE types IS\n"); }
	signal_definition_list {
		fprintf(stdout, "\tTYPE boolean_array is ARRAY(integer "
				"RANGE <>) of boolean;\n");
		fprintf(stdout, "\tTYPE integer_array is ARRAY(integer "
				"RANGE <>) of integer;\n");
		fprintf(stdout, "\tTYPE magneto_optical_array is "
			"ARRAY(integer RANGE <>) of "
			"magneto_optical;\n");
		fprintf(stdout, "END PACKAGE types;\n\n\n");
	} component_definition_list 
;

signal_definition_list:
	signal_definition_list signal_definition
	| signal_definition
;

component_definition_list:
	component_definition_list component_definition
	| component_definition
;

signal_definition:
	t_SIGNAL t_Identifier t_PRIMITIVE t_Semicolon
	| t_SIGNAL t_Identifier t_BUS t_Semicolon {
		fprintf(stdout, "\tTYPE %s is RANGE 0 to 1;\n", $2);
	}
;


component_definition:
	t_COMPONENT t_Identifier {
		fprintf(stdout, "USE types.all;\n");
		fprintf(stdout, "LIBRARY ieee;\n");
		fprintf(stdout, "USE ieee.std_logic_1164.all;\n");
		fprintf(stdout, "ENTITY %s IS\n", $2);
	} 
	t_LeftBracket component_body
	t_RightBracket {
		fprintf(stdout, "\n\t);\n");
		fprintf(stdout, "\tATTRIBUTE foreign OF %s : ENTITY "
			"IS \"%s\";\n", $2, $2);
		fprintf(stdout, "END %s;\n\n", $2);
	}
;

component_body:
	opt_generic_def port_def opt_simsetup_def
	opt_fault_injection_def
;

opt_generic_def:
	/* nothing */
	| generic_def
;

generic_def:
	t_GENERICS {
		fprintf(stdout, "\tGENERIC (\n");
	} t_LeftBracket generic_list t_RightBracket {
		fprintf(stdout, "\n\t);\n");
	}
;

generic_list:
	generic_list {
		fprintf(stdout, ";\n");
	} generic
	| generic
;

generic:
	t_Identifier t_Colon t_Identifier {
		fprintf(stdout, "\t\t%s : %s", $1, $3);
	} opt_generic_initializer t_Semicolon {
		if ($5 == 0) {
			if (strcasecmp($3, "integer") == 0) {
				fprintf(stdout, " := 0");
			} else if (strcasecmp($3, "string") == 0) {
				fprintf(stdout, " := \"\"");
			} else {
				/* type unknown */
				assert(0);
			}
		}
	}
;

opt_generic_initializer:
	/* nothing */		{ $$ = 0; }
	| generic_initializer	{ $$ = 1; }
;

generic_initializer:
	t_Equal t_Integer {
		fprintf(stdout, " := %d", $2);
	}
	| t_Equal t_String {
		fprintf(stdout, " := \"%s\"", $2);
	}
;

opt_initializer:
	/* nothing */
	| initializer
;

initializer:
	t_Equal t_Integer
	| t_Equal t_String
;



mode:
	t_IN		{ fprintf(stdout, "IN"); };
	| t_INOUT	{ fprintf(stdout, "INOUT"); }
	| t_OUT		{ fprintf(stdout, "OUT"); }
;

port_def:
	t_PORT {
		fprintf(stdout, "\tPORT (\n");
	} t_LeftBracket port_list t_RightBracket
;

port_list:
	port_list {
		fprintf(stdout, ";\n");
	} port
	| port
;

port:
	t_Identifier {
		fprintf(stdout, "\t\t%s : ", $1);
	} t_Colon mode t_Identifier t_Semicolon {
		fprintf(stdout, " %s", $5);
	}
;

opt_simsetup_def:
	/* nothing */
	| simsetup_def
;

simsetup_def:
	t_SIMSETUP t_LeftBracket opt_simsetup_list t_RightBracket
;

opt_simsetup_list:
	/* nothing */
	| simsetup_list
;

simsetup_list:
	simsetup_list simsetup
	| simsetup
;

simsetup:
	t_Identifier t_Colon t_Identifier opt_initializer t_Semicolon
;

opt_fault_injection_def:
	/* nothing */
	| fault_injection_def
;

fault_injection_def:
	t_FAULTINJECTION t_LeftBracket fault_injection_list t_RightBracket
;

fault_injection_list:
	fault_injection_list fault_injection
	| fault_injection
;

fault_injection:
	t_Identifier t_Colon t_Identifier t_Semicolon {
		fprintf(stdout, ";\n\t\t%s : %s", $1, $3);
	}
;

%%
#include <stdio.h>

static void
yyerror(const char *msg)
{
	fprintf(stderr, "%d: %s\n", yylineno, msg);
}
