/* $Id: ps2_gen_mouse_4_gui.c,v 1.7 2009-03-14 06:29:01 sand Exp $ 
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>

#include "config.h"

#include "glue-gui.h"

#include "ps2_gen_mouse_4_gui.h"

#ifdef HAVE_GTK
#include "ps2_gen_mouse_4_gui_gtk.h"
#endif

void
ps2_gen_mouse_4_gui_init(
	unsigned int nr,
	struct sig_ps2 *port_ps2,
	struct sig_integer *port_deltax,
	struct sig_integer *port_deltay,
	struct sig_integer *port_deltaz,
	struct sig_boolean *port_button1,
	struct sig_boolean *port_button2,
	struct sig_boolean *port_button3,
	struct sig_boolean *port_button4,
	struct sig_boolean *port_button5
)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		ps2_gen_mouse_4_gui_gtk_init(
				nr,
				port_ps2,
				port_deltax,
				port_deltay,
				port_deltaz,
				port_button1,
				port_button2,
				port_button3,
				port_button4,
				port_button5
				);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
ps2_gen_mouse_4_gui_create(
	unsigned int page,
	unsigned int nr,
	const char *name
)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		ps2_gen_mouse_4_gui_gtk_create(page, nr, name);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
ps2_gen_mouse_4_gui_destroy(unsigned int nr)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		ps2_gen_mouse_4_gui_gtk_destroy(nr);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}
