/*
 * $Id: power_supply_at_gui.c,v 1.2 2009-03-14 06:29:01 sand Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>

#include "config.h"

#include "glue-gui.h"

#include "power_supply_at_gui.h"

#ifdef HAVE_GTK
#include "power_supply_at_gui_gtk.h"
#endif

void
power_supply_at_gui_init(
	unsigned int nr,
	struct sig_boolean *port_power_230v,
	struct sig_boolean *port_mech_power_switch,
	struct sig_power_board_at *port_power_board,
	struct sig_power_device *port_power_dev0,
	struct sig_power_device *port_power_dev1,
	struct sig_power_device *port_power_dev2,
	struct sig_power_device *port_power_dev3,
	struct sig_power_device *port_power_dev4,
	struct sig_power_device *port_power_dev5,
	struct sig_power_device *port_power_dev6,
	struct sig_power_device *port_power_dev7
)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		power_supply_at_gui_gtk_init(
				nr,
				port_power_230v,
				port_mech_power_switch,
				port_power_board,
				port_power_dev0,
				port_power_dev1,
				port_power_dev2,
				port_power_dev3,
				port_power_dev4,
				port_power_dev5,
				port_power_dev6,
				port_power_dev7
				);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
power_supply_at_gui_create(
	unsigned int page,
	unsigned int nr,
	const char *name
)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		power_supply_at_gui_gtk_create(page, nr, name);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
power_supply_at_gui_destroy(unsigned int nr)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		power_supply_at_gui_gtk_destroy(nr);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}
