/*
 *  $Id: monitor_gui.c,v 1.7 2009-03-14 06:29:01 sand Exp $
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>

#include "config.h"

#include "glue-gui.h"

#include "monitor_gui.h"

#ifdef HAVE_GTK
#include "monitor_gui_gtk.h"
#endif

#include "monitor_gui_null.h"

void
monitor_gui_init(
	unsigned int nr,
	struct sig_boolean *port_power_230v,
	struct sig_vga *port_vga,
	struct sig_opt_rgb *port_opt_video,
	struct sig_integer *port_screenshot
)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		monitor_gui_gtk_init(
				nr,
				port_power_230v,
				port_vga,
				port_opt_video,
				port_screenshot
				);
		break;
#endif
	case GUI_NULL:
		monitor_gui_null_init(
				nr,
				port_power_230v,
				port_vga,
				port_opt_video,
				port_screenshot
				);
		break;
	default:
		assert(0);
	}
}

void
monitor_gui_create(
	unsigned int page,
	unsigned int nr,
	const char *name
)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		monitor_gui_gtk_create(page, nr, name);
		break;
#endif
	case GUI_NULL:
		monitor_gui_null_create(page, nr, name);
		break;
	default:
		assert(0);
	}
}

void
monitor_gui_destroy(unsigned int nr)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		monitor_gui_gtk_destroy(nr);
		break;
#endif
	case GUI_NULL:
		monitor_gui_null_destroy(nr);
		break;
	default:
		assert(0);
	}
}
