/*
 * $Id: misc_gen_eth_busy.c,v 1.1 2009-01-31 17:33:27 vrsieh Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>

#include "glue-main.h"
#include "glue-shm.h"

#include "misc_gen_eth_busy.h"

#define CHIP_(x) misc_gen_eth_busy_ ## x
#define CHIP "misc_gen_eth_busy"

struct cpssp {
	/* Ports */
	struct sig_boolean *port_busy;
	struct sig_eth *port_eth0;
	struct sig_eth *port_eth1;

	/* State */
	unsigned int active;
};

static void
CHIP_(recv0)(void *_cpssp, const void *buf, unsigned int buflen)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->active = 1;

	sig_eth_send(cpssp->port_eth1, cpssp, buf, buflen);
}

static void
CHIP_(recv1)(void *_cpssp, const void *buf, unsigned int buflen)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->active = 1;

	sig_eth_send(cpssp->port_eth0, cpssp, buf, buflen);
}

static void
CHIP_(timer)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	sig_boolean_set(cpssp->port_busy, cpssp, cpssp->active);

	cpssp->active = 0;

	time_call_after(TIME_HZ, CHIP_(timer), cpssp);
}

void
CHIP_(init)(
	unsigned int nr,
	struct sig_eth *port_eth0,
	struct sig_eth *port_eth1,
	struct sig_boolean *port_busy
)
{
	static const struct sig_eth_funcs eth0_funcs = {
		.recv = CHIP_(recv0),
	};
	static const struct sig_eth_funcs eth1_funcs = {
		.recv = CHIP_(recv1),
	};
	struct cpssp *cpssp;

	cpssp = shm_map(CHIP, nr, sizeof(*cpssp), 0);

	/* FIXME */

	/* Call */
	cpssp->port_eth0 = port_eth0;
	sig_eth_connect(port_eth0, cpssp, &eth0_funcs);

	cpssp->port_eth1 = port_eth1;
	sig_eth_connect(port_eth1, cpssp, &eth1_funcs);

	/* Out */
	cpssp->port_busy = port_busy;
	sig_boolean_connect_out(port_busy, cpssp, 0);

	/* In */

	time_call_after(TIME_HZ, CHIP_(timer), cpssp);
}

unsigned int
CHIP_(create)(void)
{
	static unsigned int nr = 0;
	struct cpssp *cpssp;

	shm_create(CHIP, nr, sizeof(*cpssp));
	cpssp = shm_map(CHIP, nr, sizeof(*cpssp), 0);

	/* FIXME */

	shm_unmap(cpssp, sizeof(*cpssp));

	return nr++;
}

void
CHIP_(destroy)(unsigned int nr)
{
	struct cpssp *cpssp;

	cpssp = shm_map(CHIP, nr, sizeof(*cpssp), 0);

	/* FIXME */

	shm_unmap(cpssp, sizeof(*cpssp));
	shm_destroy(CHIP, nr);
}
