/* $Id: loudspeaker.c,v 1.10 2009-03-05 18:16:02 sand Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>

#include "glue-shm.h"

#include "loudspeaker.h"

#define COMP "loudspeaker"

struct cpssp {
	struct sig_sound *port_audio_sound;
};

static void
loudspeaker_sound_samples_set(void *_cpssp, int16_t *samples)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	sig_sound_samples_set(cpssp->port_audio_sound, cpssp, samples);
}

void
loudspeaker_init(
	unsigned int nr,
	struct sig_sound *port_sound_in,
	struct sig_sound *port_audio_sound
)
{
	static const struct sig_sound_funcs sound_funcs = {
		.samples_set = loudspeaker_sound_samples_set,
	};
	struct cpssp *cpssp;

	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	/* Out */
	cpssp->port_audio_sound = port_audio_sound;

	/* In */
	sig_sound_connect(port_sound_in, cpssp, &sound_funcs);
}

void
loudspeaker_create(unsigned int nr, const char *name)
{
	struct cpssp *cpssp;

	shm_create(COMP, nr, sizeof(*cpssp));
	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	shm_unmap(cpssp, sizeof(*cpssp));
}

void
loudspeaker_destroy(unsigned int nr)
{
	struct cpssp *cpssp;

	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	shm_unmap(cpssp, sizeof(*cpssp));
	shm_destroy(COMP, nr);
}
