/*
 * $Id: ide_gen_disk_gui.c,v 1.8 2009-04-25 15:29:44 potyra Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>

#include "config.h"

#include "glue-gui.h"

#include "ide_gen_disk_gui.h"

#ifdef HAVE_GTK
#include "ide_gen_disk_gui_gtk.h"
#endif

void
ide_gen_disk_gui_init(
	unsigned int nr,
	struct sig_power_device *port_power,
	struct sig_ide_bus *port_ide,
	struct sig_fault *fault_disk_fault,
	struct sig_fault *fault_block_fault
)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		ide_gen_disk_gui_gtk_init(
				nr,
				port_power,
				port_ide,
				fault_disk_fault,
				fault_block_fault
				);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
ide_gen_disk_gui_create(
	unsigned int page,
	unsigned int nr,
	const char *name,
	const char *cow,
	const char *create,
	const char *_sync,
	const char *image,
	const char *cylinders,
	const char *heads,
	const char *sectors,
	const char *unit,
	const char *size
)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		ide_gen_disk_gui_gtk_create(
				page,
				nr,
				name,
				cow,
				create,
				_sync,
				image,
				cylinders,
				heads,
				sectors,
				unit,
				size
				);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}

}

void
ide_gen_disk_gui_destroy(unsigned int nr)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		ide_gen_disk_gui_gtk_destroy(nr);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}
