/*
 * $Id: ide_disk_ibm_dtta_350540.c,v 1.3 2009-03-13 18:37:56 vrsieh Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#define SERIAL_NUMBER(x)	ide_disk_ibm_dtta_350540_serial_number(x)
#define FIRMWARE_REVISION	"T55OA73A"
#define MODEL_NUMBER		"IBM-DTTA-350840"

#define ATA1_SUPPORT		1
#define ATA2_SUPPORT		1
#define ATA3_SUPPORT		1
#define ATA4_SUPPORT		1
#define ATA5_SUPPORT		0 /* Not supported, yet. */
#define ATA6_SUPPORT		0 /* Not supported, yet. */
#define ATA7_SUPPORT		0 /* Not supported, yet. */

#define DISK_MULTIPLE_SUPPORT		(ATA3_SUPPORT || ATA4_SUPPORT || 1)
#define     MAX_IDE_MULTIPLE_SECTOR	16
#define DISK_DMA_SUPPORT		(ATA3_SUPPORT || ATA4_SUPPORT || 1)
#define DISK_READWRITE_LONG_SUPPORT	(ATA1_SUPPORT || 0)
#define     READWRITE_LONG_BYTES	34
#define DISK_RECALIBRATE_SUPPORT	(ATA1_SUPPORT || 0)
#define DISK_NOP_SUPPORT		1
#define DISK_READ_BUFFER_SUPPORT	1
#define DISK_WRITE_BUFFER_SUPPORT	1
#define DISK_SMART_SUPPORT		1
#define DISK_POWER_MANAGEMENT_SUPPORT	(ATA4_SUPPORT || 1)
#define DISK_LOOK_AHEAD_SUPPORT		1
#define DISK_WRITE_CACHE_SUPPORT	1
#define DISK_DOWNLOAD_MICROCODE_SUPPORT	0

#define CONFIG_PIO_MODE_0_SUPPORTED		1
#define CONFIG_PIO_MODE_1_SUPPORTED		1
#define CONFIG_PIO_MODE_2_SUPPORTED		1
#define CONFIG_PIO_MODE_3_SUPPORTED		1
#define CONFIG_PIO_MODE_4_SUPPORTED		1

#define CONFIG_SW_DMA_MODE_0_SUPPORTED		1
#define CONFIG_SW_DMA_MODE_1_SUPPORTED		1
#define CONFIG_SW_DMA_MODE_2_SUPPORTED		1

#define CONFIG_MW_DMA_MODE_0_SUPPORTED		1
#define CONFIG_MW_DMA_MODE_1_SUPPORTED		1
#define CONFIG_MW_DMA_MODE_2_SUPPORTED		1

#define CONFIG_ULTRA_DMA_MODE_0_SUPPORTED	1
#define CONFIG_ULTRA_DMA_MODE_1_SUPPORTED	1
#define CONFIG_ULTRA_DMA_MODE_2_SUPPORTED	1

#define CYLINDERS			16383
#define HEADS				16
#define SECTORS				63
#define LINEAR				16514064


#include <stdio.h>

#include "ide_disk_ibm_dtta_350540.h"

#define NAME_(x)	ide_disk_ibm_dtta_350540_ ## x
#define NAME		ide_disk_ibm_dtta_350540
#define SNAME		"ide_disk_ibm_dtta_350540"

static const char *
NAME_(serial_number)(unsigned int nr)
{
	static char buf[20 + 1];

	sprintf(buf, "         WE0KET%05u", nr);

	return buf;
}

#include "arch_ide_disk.c"
