/*
 * $Id: cb_intel_eepro100.c,v 1.13 2009-01-28 12:59:17 potyra Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>

#include "glue-shm.h"

#include "chip_intel_82557_cardbus.h"

#include "cb_intel_eepro100.h"

#define COMP "cb_intel_eepro100"

struct cpssp {
	struct sig_boolean *port_opt_power_led;
	struct sig_pci_bus_idsel *sig_idsel;

	unsigned int chip;
};

static void
cb_intel_eepro100_p5V_set(void *_cpss, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpss;

	sig_boolean_set(cpssp->port_opt_power_led, cpssp, val);
}

static int
cb_intel_eepro100_c0r(void *_cpss, uint32_t addr, unsigned int bs, uint32_t *valp)
{
	struct cpssp *cpssp = (struct cpssp *) _cpss;

	if ((addr >> 11) & 1) {
		return sig_pci_bus_idsel_c0r(cpssp->sig_idsel, cpssp,
				addr, bs, valp);
	} else {
		return -1;
	}
}

static int
cb_intel_eepro100_c0w(void *_cpss, uint32_t addr, unsigned int bs, uint32_t val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpss;

	if ((addr >> 11) & 1) {
		return sig_pci_bus_idsel_c0w(cpssp->sig_idsel, cpssp,
				addr, bs, val);
	} else {
		return -1;
	}
}

void
cb_intel_eepro100_init(
	unsigned int nr,
	struct sig_cardbus *port_card,
	struct sig_eth *port_eth,
	struct sig_boolean *port_opt_power_led,
	struct sig_boolean *port_opt_busy_led,
	struct sig_fault *fault_recv_loss,
	struct sig_fault *fault_send_loss
)
{
	static const struct sig_boolean_funcs p5V_funcs = {
		.set = cb_intel_eepro100_p5V_set,
	};
	static const struct sig_pci_bus_main_funcs pci_bus_funcs = {
		.c0r = cb_intel_eepro100_c0r,
		.c0w = cb_intel_eepro100_c0w,
	};
	struct cpssp *cpssp;

	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	cpssp->port_opt_power_led = port_opt_power_led;
	cpssp->sig_idsel = sig_pci_bus_idsel_init(COMP "-sig_idsel", nr);

	sig_boolean_connect_in(port_card->p5V, cpssp, &p5V_funcs);
	sig_pci_bus_main_connect(port_card->bus, cpssp, &pci_bus_funcs);

	chip_intel_82557_cardbus_init(cpssp->chip,
			port_card->p5V,
			port_card->n_reset, cpssp->sig_idsel,
			port_card->bus, port_card->irq,
			port_eth, port_opt_busy_led);
}

void
cb_intel_eepro100_create(unsigned int nr, const char *name, const char *mac)
{
	struct cpssp *cpssp;

	shm_create(COMP, nr, sizeof(*cpssp));
	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	sig_pci_bus_idsel_create(COMP "-sig_idsel", nr);

	cpssp->chip = chip_intel_82557_cardbus_create(mac);

	shm_unmap(cpssp, sizeof(*cpssp));
}

void
cb_intel_eepro100_destroy(unsigned int nr)
{
	struct cpssp *cpssp;

	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	sig_pci_bus_idsel_destroy(COMP "-sig_idsel", nr);

	chip_intel_82557_cardbus_destroy(cpssp->chip);

	shm_unmap(cpssp, sizeof(*cpssp));
	shm_destroy(COMP, nr);
}
