/* $Id: sig_serial.c,v 1.8 2009-01-27 17:06:42 potyra Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>

#include "glue-shm.h"

#include "sig_serial.h"

void
sig_serial_send(
	struct sig_serial *b,
	void *s,
	uint8_t c
)
{
	unsigned int nr;

	for (nr = 0; ; nr++) {
		if (nr == b->nmembers) {
			return;
		}
		if (b->member[nr].s == s) {
			continue;
		}
		b->member[nr].f->recv(b->member[nr].s, c);
	}
}

void
sig_serial_connect(
	struct sig_serial *b,
	void *s,
	const struct sig_serial_funcs *f
)
{
	assert(b->nmembers < sizeof(b->member) / sizeof(b->member[0]));
	assert(b->type == SIG_GEN_SERIAL);

	b->member[b->nmembers].s = s;
	b->member[b->nmembers].f = f;
	b->nmembers++;
}

struct sig_serial *
sig_serial_init(const char *name, int nr)
{
	struct sig_serial *sig;

	sig = shm_map(name, nr, sizeof(*sig), 0);

	sig->nmembers = 0;
	sig->type = SIG_GEN_SERIAL;

	return sig;
}

void
sig_serial_create(const char *name, int nr)
{
	shm_create(name, nr, sizeof(struct sig_serial));
}

void
sig_serial_destroy(const char *name, int nr)
{
	shm_destroy(name, nr);
}
