/*
 * $Id: sig_magneto_optical.h,v 1.5 2009-03-26 16:05:58 vrsieh Exp $
 *
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SIG_MAGNETO_OPTICAL_H_INCLUDED
#define __SIG_MAGNETO_OPTICAL_H_INCLUDED

#include <inttypes.h>

struct sig_magneto_optical_funcs {
	int (*read)(void *cpssp, unsigned long long blk, uint8_t *buf);
	int (*write)(void *cpssp, unsigned long long blk, const uint8_t *buf);
};

struct sig_magneto_optical {
	struct {
		void *s;
		const struct sig_magneto_optical_funcs *f;
	} member[10];
	int member_count;
};

struct sig_magneto_optical_merge {
	struct sig_magneto_optical *s0;
	struct sig_magneto_optical *s1;
};

extern int
sig_magneto_optical_read(struct sig_magneto_optical *b, void *s,
		unsigned long long blk, uint8_t *buf);
extern int
sig_magneto_optical_write(struct sig_magneto_optical *b, void *s,
		unsigned long long blk, const uint8_t *buf);

extern void
sig_magneto_optical_connect(struct sig_magneto_optical *sig,
		void *s, const struct sig_magneto_optical_funcs *f);

extern struct sig_magneto_optical *
sig_magneto_optical_init(const char *name, int nr);

extern struct sig_magneto_optical_merge *
sig_magneto_optical_merge(struct sig_magneto_optical *s0,
		struct sig_magneto_optical *s1);
extern void
sig_magneto_optical_split(struct sig_magneto_optical_merge *m);

extern void
sig_magneto_optical_create(const char *name, int nr);
extern void
sig_magneto_optical_destroy(const char *name, int nr);

#endif /* __SIG_MAGNETO_OPTICAL_H_INCLUDED */
