/*
 * $Id: sig_magneto_optical.c,v 1.2 2009-03-26 16:05:58 vrsieh Exp $
 *
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include "fixme.h"
#include <stdio.h>
#include <stdlib.h>

#include "glue-shm.h"

#include "sig_magneto_optical.h"

int
sig_magneto_optical_read(
	struct sig_magneto_optical *b,
	void *s,
	unsigned long long blk,
	uint8_t *buf
)
{
	unsigned int nr;

	for (nr = 0; ; nr++) {
		int (*func)(void *, unsigned long long, uint8_t *);

		if (nr == b->member_count) {
			return -1;
		}
		func = b->member[nr].f->read;
		if (func) {
			return func(b->member[nr].s, blk, buf);
		}
	}
}

int
sig_magneto_optical_write(
	struct sig_magneto_optical *b,
	void *s,
	unsigned long long blk,
	const uint8_t *buf
)
{
	unsigned int nr;

	for (nr = 0; ; nr++) {
		int (*func)(void *, unsigned long long, const uint8_t *);

		if (nr == b->member_count) {
			return -1;
		}
		func = b->member[nr].f->write;
		if (func) {
			return func(b->member[nr].s, blk, buf);
		}
	}
}

void
sig_magneto_optical_connect(
	struct sig_magneto_optical *b,
	void *s,
	const struct sig_magneto_optical_funcs *f
)
{
	assert(b);
	assert(b->member_count < sizeof(b->member) / sizeof(b->member[0]));

	b->member[b->member_count].s = s;
	b->member[b->member_count].f = f;
	b->member_count++;
}

struct sig_magneto_optical *
sig_magneto_optical_init(const char *name, int nr)
{
	struct sig_magneto_optical *sig;

	sig = shm_map(name, nr, sizeof(*sig), 0);

	sig->member_count = 0;

	return sig;
}

static int
sig_magneto_optical_s0_read(void *_f, unsigned long long blk, uint8_t *buf)
{
	struct sig_magneto_optical_merge *f = _f;

	return sig_magneto_optical_read(f->s1, f, blk, buf);
}

static int
sig_magneto_optical_s0_write(void *_f, unsigned long long blk, const uint8_t *buf)
{
	struct sig_magneto_optical_merge *f = _f;

	return sig_magneto_optical_write(f->s1, f, blk, buf);
}

static int
sig_magneto_optical_s1_read(void *_f, unsigned long long blk, uint8_t *buf)
{
	struct sig_magneto_optical_merge *f = _f;

	return sig_magneto_optical_read(f->s0, f, blk, buf);
}

static int
sig_magneto_optical_s1_write(void *_f, unsigned long long blk, const uint8_t *buf)
{
	struct sig_magneto_optical_merge *f = _f;

	return sig_magneto_optical_write(f->s0, f, blk, buf);
}

struct sig_magneto_optical_merge *
sig_magneto_optical_merge(
	struct sig_magneto_optical *s0,
	struct sig_magneto_optical *s1
)
{
	static const struct sig_magneto_optical_funcs s0_funcs = {
		.read = sig_magneto_optical_s0_read,
		.write = sig_magneto_optical_s0_write,
	};
	static const struct sig_magneto_optical_funcs s1_funcs = {
		.read = sig_magneto_optical_s1_read,
		.write = sig_magneto_optical_s1_write,
	};
	struct sig_magneto_optical_merge *m;

	m = malloc(sizeof(*m));
	assert(m);

	/* Out */
	m->s0 = s0;
	m->s1 = s1;

	/* In */
	sig_magneto_optical_connect(s0, m, &s0_funcs);
	sig_magneto_optical_connect(s1, m, &s1_funcs);

	return m;
}

void
sig_magneto_optical_split(struct sig_magneto_optical_merge *m)
{
#if 1
	fixme();
#else
	sig_magneto_optical_disconnect(s0, m);
	sig_magneto_optical_disconnect(s1, m);
#endif
}

void
sig_magneto_optical_create(const char *name, int nr)
{
	shm_create(name, nr, sizeof(struct sig_magneto_optical));
}

void
sig_magneto_optical_destroy(const char *name, int nr)
{
	shm_destroy(name, nr);
}
