/* $Id: cim_opt_rgb.c,v 1.2 2009-01-27 17:06:39 potyra Exp $ 
 *
 * Copyright (C) 2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <string.h>

#include "cim_opt_rgb.h"

struct cim_opt_rgb_buf {
	enum { CIM_OPT_RGB_PIXEL, CIM_OPT_RGB_SIZE, CIM_OPT_RGB_SYNC } type;
	union {
		struct {
			uint32_t x;
			uint32_t y;
			uint8_t r;
			uint8_t g;
			uint8_t b;
		} pixel;
		struct {
			uint32_t width;
			uint32_t height;
		} size;
		struct {
			uint32_t sync_dummy; /* Not used. */
		} sync;
	};
};

static void
cim_opt_rgb__pixel_set(void *_css, unsigned int x, unsigned int y,
		uint8_t r, uint8_t g, uint8_t b)
{
	struct cim_opt_rgb *css = (struct cim_opt_rgb *) _css;
	struct cim_opt_rgb_buf buf;

	buf.type = CIM_OPT_RGB_PIXEL;
	buf.pixel.x = x;
	buf.pixel.y = y;
	buf.pixel.r = r;
	buf.pixel.g = g;
	buf.pixel.b = b;

	cim_send(&css->bridge, &buf, sizeof(buf));
}

static void
cim_opt_rgb__size_set(void *_css, unsigned int width, unsigned int height)
{
	struct cim_opt_rgb *css = (struct cim_opt_rgb *) _css;
	struct cim_opt_rgb_buf buf;

	buf.type = CIM_OPT_RGB_SIZE;
	buf.size.width = width;
	buf.size.height = height;

	cim_send(&css->bridge, &buf, sizeof(buf));
}

static void
cim_opt_rgb__sync(void *_css)
{
	struct cim_opt_rgb *css = (struct cim_opt_rgb *) _css;
	struct cim_opt_rgb_buf buf;

	buf.type = CIM_OPT_RGB_SYNC;

	cim_send(&css->bridge, &buf, sizeof(buf));
}

void
cim_opt_rgb_init(struct cim_opt_rgb *css, struct sig_opt_rgb *sig_opt_rgb)
{
	static const struct sig_opt_rgb_funcs funcs = {
		.pixel_set = cim_opt_rgb__pixel_set,
		.size_set = cim_opt_rgb__size_set,
		.sync = cim_opt_rgb__sync,
	};

	css->sig_opt_rgb = sig_opt_rgb;
	sig_opt_rgb_connect(sig_opt_rgb, css, &funcs);
}

void
cim_opt_rgb_create(struct cim_opt_rgb *css)
{
	cim_create(&css->bridge);
}

void
cim_opt_rgb_destroy(struct cim_opt_rgb *css)
{
	cim_destroy(&css->bridge);
}
