/* $Id: cim_fault.c,v 1.5 2009-01-27 17:06:39 potyra Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>

#include "cim_fault.h"

struct cim_fault_msg {
	unsigned long long loc0;
	unsigned long long loc1;
	unsigned int val;
};

static void
cim_fault_set(
	void *_css,
	unsigned long long loc0,
	unsigned long long loc1,
	unsigned int val
)
{
	struct cim_fault *css = (struct cim_fault *) _css;
	struct cim_fault_msg msg;

	msg.loc0 = loc0;
	msg.loc1 = loc1;
	msg.val = val;
	cim_send(&css->bridge, &msg, sizeof(msg));
}

static void
cim_fault_receive(void *_css, void *_msg, unsigned int bufsize)
{
	struct cim_fault *css = (struct cim_fault *) _css;
	struct cim_fault_msg *msg = (struct cim_fault_msg *) _msg;

	assert(sizeof(*msg) == bufsize);

	sig_fault_set(css->sig_fault, css, msg->loc0, msg->loc1, msg->val);
}

void
cim_fault_init(struct cim_fault *css, struct sig_fault *sig_fault)
{
	static const struct sig_fault_funcs funcs = {
		.set = cim_fault_set,
	};

	cim_connect(&css->bridge, cim_fault_receive, css);

	css->sig_fault = sig_fault;
	sig_fault_connect(sig_fault, css, &funcs);
}

void
cim_fault_create(struct cim_fault *css)
{
	cim_create(&css->bridge);
}

void
cim_fault_destroy(struct cim_fault *css)
{
	cim_destroy(&css->bridge);
}
