/* $Id: serial_modem_dialout.h,v 1.3 2009-01-28 13:57:51 potyra Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __MODEM_DIALOUT_H
#define __MODEM_DIALOUT_H

#include <stdbool.h>

#include "sig_telephone.h"

/* dial modes */
enum dial_modes {
	DIAL_MODE_TONE,
	DIAL_MODE_PULSE
};

/** dial given number 
 *  @param number destination number 
 *  @param mode pulse or tone dialing mode. */
void
modem_dialout_dial(unsigned long number, enum dial_modes mode);

/** char sent to dialout module.
 *  @param c byte of data. */
void
modem_dialout_push_char(unsigned char c);

/** should dialout module use data coming from serial line?
 *  FIXME dialout should only be talked to from fsm.
 *  @param useit true if serial line data should be forwarded. */
void
modem_dialout_set_serbusstate(bool useit);

/** hangup the line */
void
modem_dialout_hangup(void);

/** lift the receiver (answer call)
 */
void
modem_dialout_lift(void);

extern void
dialout_interrupt_data(void *s, uint8_t data);
extern void
dialout_interrupt_ctrl(void *s, enum sig_telephone_protocol event);
extern void
dialout_interrupt_dial(void *s, uint32_t number);

/** terminate dialout module (hang up, in case still connected)
 */
void
modem_dialout_exit(void);

#endif /* __MODEM_DIALOUT_H */
