/* $Id: scsi_gen_cdrom.c,v 1.43 2009-01-28 12:59:21 potyra Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

/* This will turn on packet command debug output. */
#define DEBUGPCOM	0

/*
 * Config Options
 */
#define CD_AUDIO_SUPPORT                0
#define CD_WRITER_SUPPORT               1
#define CD_CHANGER_SUPPORT              0

/* CD_WRITER_SUPPORT */
#define CD_WRITER_RW_SUPPORT            0
#define CD_WRITER_DAO_SUPPORT           0

#define CD_PLAY_CD_SUPPORT              0
#define CD_READ_CD_SUPPORT              0
#define CD_SCAN_CD_SUPPORT              0


#include "config.h"

#include <inttypes.h>

#include <assert.h>
#include <fcntl.h>
#include "fixme.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "qemu/bswap.h"
#include "sig_ide.h"
#include "cd_image.h"
#include "glue-log.h"
#include "glue-main.h"
#include "glue-shm.h"
#include "glue-storage.h"

#include "scsi_gen_cdrom.h"

#define COMP "scsi_gen_cdrom"

struct cpssp {
	/* Config */

	/* Ports */
	struct sig_boolean *port_5V;
	struct sig_boolean *port_12V;
	struct sig_scsi_bus *port_scsi_bus;

	/* State */

#define STATE

#define NAME            cdrom
#define NAME_(x)        cdrom_ ## x
#define SNAME           "cdrom"
#include "arch_scsi_gen_cdrom.c"
#undef SNAME
#undef NAME_
#undef NAME

#undef STATE
};

static void
cdrom_phase_msg_out(struct cpssp *cpssp)
{
	sig_scsi_bus_phase_msg_out(cpssp->port_scsi_bus, cpssp);
}

static void
cdrom_phase_msg_in(struct cpssp *cpssp)
{
	sig_scsi_bus_phase_msg_in(cpssp->port_scsi_bus, cpssp);
}

static void
cdrom_phase_cmd(struct cpssp *cpssp)
{
	sig_scsi_bus_phase_command(cpssp->port_scsi_bus, cpssp);
}

static void
cdrom_phase_data_in(struct cpssp *cpssp)
{
	sig_scsi_bus_phase_data_in(cpssp->port_scsi_bus, cpssp);
}

static void
cdrom_phase_data_out(struct cpssp *cpssp)
{
	sig_scsi_bus_phase_data_out(cpssp->port_scsi_bus, cpssp);
}

static void
cdrom_phase_status(struct cpssp *cpssp)
{
	sig_scsi_bus_phase_status(cpssp->port_scsi_bus, cpssp);
}

static void
cdrom_phase_free(struct cpssp *cpssp)
{
	sig_scsi_bus_phase_free(cpssp->port_scsi_bus, cpssp);
}

static void
cdrom_want_recv(struct cpssp *cpssp, unsigned long count)
{
	sig_scsi_bus_want_recv(cpssp->port_scsi_bus, cpssp, count);
}

static void
cdrom_want_send(struct cpssp *cpssp, unsigned long count)
{
	sig_scsi_bus_want_send(cpssp->port_scsi_bus, cpssp, count);
}

#define BEHAVIOR

#define NAME            cdrom
#define NAME_(x)        cdrom_ ## x
#define SNAME           "cdrom"
#include "arch_scsi_gen_cdrom.c"
#undef SNAME
#undef NAME_
#undef NAME

#undef BEHAVIOR

static void
scsi_gen_cdrom_power_set(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	cdrom_power_set(cpssp, val);
}

static int
scsi_gen_cdrom_phase_select(void *_cpssp, uint32_t id)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	return cdrom_phase_select(cpssp, id);
}

static int
scsi_gen_cdrom_phase_reselect(void *_cpssp, uint32_t id)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	return cdrom_phase_reselect(cpssp, id);
}

static void
scsi_gen_cdrom_phase_msg_out(void *_cpssp)
{
	/* Nothing to do... */
}

static void
scsi_gen_cdrom_phase_msg_in(void *_cpssp)
{
	/* Nothing to do... */
}

static void
scsi_gen_cdrom_phase_command(void *_cpssp)
{
	/* Nothing to do... */
}

static void
scsi_gen_cdrom_phase_data_out(void *_cpssp)
{
	/* Nothing to do... */
}

static void
scsi_gen_cdrom_phase_data_in(void *_cpssp)
{
	/* Nothing to do... */
}

static void
scsi_gen_cdrom_phase_status(void *_cpssp)
{
	/* Nothing to do... */
}


static void
scsi_gen_cdrom_phase_free(void *_cpssp)
{
	/* Nothing to do... */
}

static void
scsi_gen_cdrom_atn_set(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	return cdrom_atn_set(cpssp, val);
}

void
scsi_gen_cdrom_want_recv(
	void *_cpssp,
	unsigned long bufsize
)
{
/* called always from the target ==> not relevant here! */
}

void
scsi_gen_cdrom_want_send(
	void *_cpssp,
	unsigned long bufsize
)
{
/* called always from the target ==> not relevant here! */
}

static unsigned long
scsi_gen_cdrom_send(
	void *_cpssp,
	const uint8_t *buf,
	unsigned long bufsize
)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	return cdrom_send(cpssp, buf, bufsize);
}

static unsigned long
scsi_gen_cdrom_recv(
	void *_cpssp,
	uint8_t *buf,
	unsigned long bufsize
)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	return cdrom_recv(cpssp, buf, bufsize);
}

static void
scsi_gen_cdrom_change(void *_cpssp, const char *path)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	cdrom_change(cpssp, path);
}

void
scsi_gen_cdrom_init(
	unsigned int nr,
	struct sig_power_device *port_power,
	struct sig_scsi_bus *port_scsi,
	struct sig_string *port_change
)
{
	static const struct sig_boolean_funcs power_funcs = {
		.set = scsi_gen_cdrom_power_set,
	};
	static const struct sig_scsi_bus_funcs funcs = {
		.phase_select = scsi_gen_cdrom_phase_select,
		.phase_reselect = scsi_gen_cdrom_phase_reselect,
		.phase_msg_out = scsi_gen_cdrom_phase_msg_out,
		.phase_msg_in = scsi_gen_cdrom_phase_msg_in,
		.phase_command = scsi_gen_cdrom_phase_command,
		.phase_data_out = scsi_gen_cdrom_phase_data_out,
		.phase_data_in = scsi_gen_cdrom_phase_data_in,
		.phase_status = scsi_gen_cdrom_phase_status,
		.phase_free = scsi_gen_cdrom_phase_free,

		.atn_set = scsi_gen_cdrom_atn_set,

		/* called always from the target ==> not relevant here! */
		.want_recv = scsi_gen_cdrom_want_recv,
		.want_send = scsi_gen_cdrom_want_send,

		/* these 2 are relevant */
		.send = scsi_gen_cdrom_send,
		.recv = scsi_gen_cdrom_recv,
	};
	static const struct sig_string_funcs change_funcs = {
		.set = scsi_gen_cdrom_change,
	};
	struct cpssp *cpssp;

	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	cpssp->port_5V = port_power->power_5V;
	sig_boolean_connect_in(port_power->power_5V, cpssp, &power_funcs);
	cpssp->port_12V = port_power->power_12V;

	cpssp->port_scsi_bus = port_scsi;
	sig_scsi_bus_connect(port_scsi, cpssp, &funcs);

	sig_string_connect(port_change, cpssp, &change_funcs);

	cdrom_init(cpssp);
}

void
scsi_gen_cdrom_create(
	unsigned int nr,
	const char *name,
	const char *scsi_id_str
)
{
	struct cpssp *cpssp;
	int scsi_id;
	char path[1024];

	shm_create(COMP, nr, sizeof(*cpssp));
	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	scsi_id = strtoul(scsi_id_str, NULL, 0);

	/* Shoudn't be necessary! FIXME */
	assert(strlen(COMP "-XX.media") + 1 <= sizeof(path));
	sprintf(path, COMP "-%d.media", nr);

	cdrom_create(cpssp, path, scsi_id);

	shm_unmap(cpssp, sizeof(*cpssp));
}

void
scsi_gen_cdrom_destroy(unsigned int nr)
{
	struct cpssp *cpssp;

	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	cdrom_destroy(cpssp);

	shm_unmap(cpssp, sizeof(*cpssp));
	shm_destroy(COMP, nr);
}
