/* $Id: network_bridge.c,v 1.16 2009-01-28 12:59:21 potyra Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#define DBG_DUMP	0

#include "config.h"

#include <assert.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "glue-main.h"

#include "network_setup.h"
#include "network_tap.h"

#include "network_bridge.h"

static struct sig_eth *cpssp_port_eth;

static const struct real_ops *real;


static int
dump(const char *string, const unsigned char *buf, int bufsize)
{
#if DBG_DUMP
	static unsigned char broadcast[6] = {
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff
	};
	int i;
	char arp=0 ;

#if 0
	/* FIXME - won't work with CIM/bridge */
	if (memcmp(buf, broadcast, 6) != 0
	 && memcmp(buf + 6, broadcast, 6) != 0) {
		for (i = 0; ; i++) {
			if (i == 16) {
				/* foreign packet => don't dump */
				/* fprintf(stderr, "foreign packet!\n") ; */
				return 0;
			}
			if (host[i].addr == 0
			 || host[i].port == 0) {
				continue;
			}
			if (memcmp(buf, host[i].mac, 6) == 0
			 || memcmp(buf + 6, host[i].mac, 6) == 0) {
				break;
			}
		}
	}
#endif

	if (((*((char*)(&buf[12]))) == (char)0x08) &&
		((*((char*)(&buf[13]))) == (char)0x06)) {
		arp = 1 ;
	}
	fprintf(stderr, "%s len(%d):", string, bufsize);
	for (i = 0; i < bufsize && i < (160 - strlen(string)) / 3; i++) {
		fprintf(stderr, " %02x", buf[i]);
		switch(i) {
		case 5:
		case 11:
			fprintf(stderr, " |") ; break ;
		case 13:
			fprintf(stderr, " ||\n\t") ; break ;
		case 15:
		case 17:
		case 18:
		case 19:
		case 21:
		case 27:
		case 31:
		case 37:
		case 41:
			if (arp) { fprintf(stderr, " |") ; } break ;
		default:
			break ;
		}
	}
	fprintf(stderr, "\n");
	return 1 ;
#endif
#if !DBG_DUMP
	return 0 ;
#endif
}

void
bridge_real_to_virt(unsigned char *buf, unsigned int bufsize)
{
	int dumped;

	dumped = dump("#### phys -> virt ### start\np->v", buf, bufsize);

	/* fix packet by padding with zeros */
	/* Linux bridging code seems to truncate padding ??! */
	while (bufsize < 60) {
		buf[bufsize++] = 0;
	}
	sig_eth_send(cpssp_port_eth, &cpssp_port_eth, buf, bufsize);

	if (dumped) { fprintf(stderr, "#### phys -> virt ### end\n") ;}
}

static void
bridge_virt_to_real(void *_css, const void *buf, unsigned int bufsize)
{
	int dumped;
	int ret;

	dumped = dump("#### virt -> phys ### start\nv->p", buf, bufsize);

	ret = real->send(buf, bufsize);
	if (ret < 0) {
		fprintf(stderr, "%s: phys_send: %s.\n",
				progname,
				strerror(errno));
	}

	if (dumped) { fprintf(stderr, "#### virt -> phys ### end\n") ; }
}

void
network_bridge_init(
	unsigned int nr,
	struct sig_eth *port_eth
)
{
	static const struct sig_eth_funcs eth_funcs = {
		.recv = bridge_virt_to_real,
	};

	cpssp_port_eth = port_eth;

	real->init();

	sig_eth_connect(cpssp_port_eth, &cpssp_port_eth, &eth_funcs);
}

void
network_bridge_create(
	unsigned int nr,
	const char *name,
	const char *interface
)
{
	assert(interface);

	real = tuntap_config(interface);
	assert(real);
}

void
network_bridge_destroy(unsigned int nr)
{
}
