/*
 * $Id: ide_gen_disk_gui_gtk.c,v 1.11 2009-01-28 12:59:20 potyra Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>

#include "glue-gui-gtk.h"
#include "gui-gtk.h"

#include "ide_gen_disk_gui.h"

#define COMP "ide_gen_disk"

struct cpssp {
	unsigned long nblks;

	struct sig_fault *fault_disk_fault;
	struct sig_fault *fault_block_fault;

	GtkWidget *gui_fi;
};

static struct cpssp *iface[100];

/*
 * Simulator Callbacks
 */

/*
 * GUI Callbacks
 */
static void
ide_gen_disk_gui_disk_fault_event(
	GtkWidget *w,
	gpointer _fault,
	gpointer _cpssp
)
{
	struct fault {
		unsigned int state;
		const char *loc0[4];
		const char *loc1[4];
	} *fault = (struct fault *) _fault;
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	sig_fault_set(cpssp->fault_disk_fault, cpssp, 0, 0, fault->state);

	free(fault);
}

static void
ide_gen_disk_gui_block_fault_event(
	GtkWidget *w,
	gpointer _fault,
	gpointer _cpssp
)
{
	struct fault {
		unsigned int state;
		const char *loc0[4];
		const char *loc1[4];
	} *fault = (struct fault *) _fault;
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	sig_fault_set(cpssp->fault_block_fault, cpssp,
			strtoul(fault->loc0[0], NULL, 0), 0, fault->state);

	free(fault);
}

void
ide_gen_disk_gui_init(
	unsigned int nr,
	struct sig_power_device *port_power,
	struct sig_ide_bus *port_ide,
	struct sig_fault *fault_disk_fault,
	struct sig_fault *fault_block_fault
)
{
	struct cpssp *cpssp;

	cpssp = iface[nr];
	assert(cpssp);

	cpssp->fault_disk_fault = fault_disk_fault;
	cpssp->fault_block_fault = fault_block_fault;
}

void
ide_gen_disk_gui_create(
	unsigned int page,
	unsigned int nr,
	const char *name,
	const char *cow,
	const char *create,
	const char *sparse,
	const char *_sync,
	const char *image,
	const char *cylinders,
	const char *heads,
	const char *sectors,
	const char *unit,
	const char *size
)
{
	struct cpssp *cpssp;
	GtkWidget *w;

	cpssp = malloc(sizeof(*cpssp));
	assert(cpssp);

	if (! size) size = "2047";

	cpssp->nblks = strtoul(size, NULL, 0) * (1024*1024) / 512;

	cpssp->gui_fi = gtk_vbox_new(FALSE, 1);
	
	w = gui_gtk_fi_new("Disk Fault", "Boolean");
	g_signal_connect(G_OBJECT(w), "fi-change",
			G_CALLBACK(ide_gen_disk_gui_disk_fault_event),
			cpssp);
	gtk_widget_show(w);
	gtk_box_pack_start(GTK_BOX(cpssp->gui_fi), w, FALSE, FALSE, 1);

	w = gui_gtk_fi_pattern_new(
		"Block Fault", "Boolean",
		1, "Block", 0ULL, (unsigned long long) cpssp->nblks - 1, NULL,
		0);
	g_signal_connect(G_OBJECT(w), "fi-change",
			G_CALLBACK(ide_gen_disk_gui_block_fault_event),
			cpssp);
	gtk_widget_show(w);
	gtk_box_pack_start(GTK_BOX(cpssp->gui_fi), w, FALSE, FALSE, 1);

	gui_comp_add(page, COMP, nr, name, NULL, FALSE, FALSE, cpssp->gui_fi);

	iface[nr] = cpssp;
}

void
ide_gen_disk_gui_destroy(unsigned int nr)
{
	struct cpssp *cpssp;

	cpssp = iface[nr];
	assert(cpssp);

	free(cpssp);
	iface[nr] = NULL;
}
