/*
 * $Id: conn_usb.c,v 1.5 2009-01-28 12:59:19 potyra Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "glue-shm.h"

#include "conn_usb.h"

#define COMP	"conn_usb"

struct cpssp {
	struct sig_boolean_merge *forward_power;
	struct sig_usb_bus_main_merge *forward_main;
};

void
conn_usb_init(
	unsigned int nr,

	struct sig_usb_bus *port_usb,

	struct sig_boolean *port_power,
	struct sig_usb_bus_main *port_main
)
{
	struct cpssp *cpssp;

	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	cpssp->forward_main = sig_usb_bus_main_merge(port_usb->bus, port_main);
	cpssp->forward_power = sig_boolean_merge(port_power, port_usb->power);
}

unsigned int
conn_usb_create(void)
{
	static unsigned int nr = 0;

	shm_create(COMP, nr, sizeof(struct cpssp));

	return nr++;
}

void
conn_usb_destroy(unsigned int nr)
{
	shm_destroy(COMP, nr);
}
