/*
 * $Id: conn_pci.c,v 1.10 2009-01-28 12:59:19 potyra Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "glue-shm.h"

#include "conn_pci.h"

#define COMP	"conn_pci"

struct cpssp {
	struct sig_boolean_merge *forward_p5V;
	struct sig_boolean_merge *forward_p12V;
	struct sig_boolean_merge *forward_m12V;
	struct sig_boolean_merge *forward_n_reset;
	struct sig_pci_bus_idsel_merge *forward_idsel;
	struct sig_pci_bus_main_merge *forward_main;
	struct sig_boolean_or_merge *forward_intA;
	struct sig_boolean_or_merge *forward_intB;
	struct sig_boolean_or_merge *forward_intC;
	struct sig_boolean_or_merge *forward_intD;
};

void
conn_pci_init(
	unsigned int nr,

	struct sig_pci_bus *dev,

	struct sig_boolean *mb_p5V,
	struct sig_boolean *mb_p12V,
	struct sig_boolean *mb_m12V,
	struct sig_boolean *mb_n_reset,
	struct sig_pci_bus_idsel *mb_idsel,
	struct sig_pci_bus_main *mb_main,
	struct sig_boolean_or *mb_intA,
	struct sig_boolean_or *mb_intB,
	struct sig_boolean_or *mb_intC,
	struct sig_boolean_or *mb_intD
)
{
	struct cpssp *cpssp;

	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	cpssp->forward_p5V = sig_boolean_merge(mb_p5V, dev->p5V);
	cpssp->forward_p12V = sig_boolean_merge(mb_p12V, dev->p12V);
	cpssp->forward_m12V = sig_boolean_merge(mb_m12V, dev->m12V);
	cpssp->forward_n_reset = sig_boolean_merge(mb_n_reset, dev->n_reset);
	cpssp->forward_idsel = sig_pci_bus_idsel_merge(mb_idsel, dev->idsel);
	cpssp->forward_main = sig_pci_bus_main_merge(mb_main, dev->main);
	cpssp->forward_intA = sig_boolean_or_merge(dev->intA, mb_intA);
	cpssp->forward_intB = sig_boolean_or_merge(dev->intB, mb_intB);
	cpssp->forward_intC = sig_boolean_or_merge(dev->intC, mb_intC);
	cpssp->forward_intD = sig_boolean_or_merge(dev->intD, mb_intD);
}

unsigned int
conn_pci_create(void)
{
	static unsigned int nr = 0;

	shm_create(COMP, nr, sizeof(struct cpssp));

	return nr++;
}

void
conn_pci_destroy(unsigned int nr)
{
	shm_destroy(COMP, nr);
}
