/*
 * $Id: sigs_and_comps.h,v 1.15 2009-01-27 17:44:20 potyra Exp $
 *
 * Copyright (C) 2005-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef SIGS_AND_COMPS_H
#define SIGS_AND_COMPS_H

extern void sac_init(const char *);

/* for internal use at setup.c/structure.c */
extern void sac_reset_component_index(void);
extern int sac_get_component_index(const char *name);

/* list of pointers of defined signal names */
extern struct list_header *sac_sig_list(void);
/* check if connect_component flag for a signal is set */
extern int sac_sig_connect_component(const char *name);
/* check if bus flag for a signal is set */
extern int sac_sig_isbus(const char *name);
/* check if a component exists, true if existent, else false */
extern int sac_component_exists(const char *name);
/* get bridge status (SIGNAME, TCP, UDP,...) of a signal */
extern const char *sac_bridge_config(const char *name);

/* automatic generic setting, used from structure.c */
extern const char *sac_generic_callback(const char *comp_name, const char *generic_name);
extern struct list_header *sac_generic_defaults(const char *comp_name, const char *generic_name);

/* for Christoph D. */

/* list of defined component names */
extern struct list_header *sac_comp_list(void);
/* get list of generic names of the specified component */
extern struct list_header *sac_comp_generic_names(const char *comp_name);
/* get the type of a generic (of a component) */
extern const char *sac_comp_generic_type(const char *comp_name, const char *generic_name);
/* get the first initializer of the named generic. if there is non, NULL is returned */
extern const char *sac_comp_generic_first_initializer(const char *comp_name, const char *generic_name);

extern struct list_header *sac_simsetup_defaults(const char *comp_name, const char *simsetup_name);
/* get list of generic names of the specified component */
extern struct list_header *sac_comp_simsetup_names(const char *comp_name);
/* get the first initializer of the named simsetup. if there is non, NULL is returned */
extern const char *sac_comp_simsetup_first_initializer(const char *comp_name, const char *simsetup_name);

/* get list of port names of the specified component */
extern struct list_header *sac_comp_port_names(const char *comp_name);
extern const char *sac_comp_port_type(const char *comp_name, const char *port_name);
extern const char *sac_comp_port_dir(const char *comp_name, const char *port_name);

/* fault injection signals of a component */
extern struct list_header *sac_comp_fault_names(const char *comp_name);
extern const char *sac_comp_fault_type(const char *comp_name, const char *fault_name);

/* get list of internal signals (e.g. pattern matcher shortcuts) */
extern struct list_header *sac_comp_internal_names(const char *comp_name);
extern const char *sac_comp_internal_type(const char *comp_name, const char *internal_name);

/* get list of hefkg settings (e.g. is it possible to find it in a store, icon, ...) */
extern struct list_header *sac_comp_hefkg_names(const char *comp_name);
extern const char *sac_comp_hefkg_type(const char *comp_name, const char *hefkg_name);

/* free resources got from sac_sig_list, sac_comp_{list|generic_names|port_names|fault_names|internal_names|...} */
extern void sac_free_list(struct list_header *);

#endif
