/*
 * $Id: sig_power.h,v 1.9 2009-01-27 17:44:20 potyra Exp $
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SIG_POWER_H_INCLUDED
#define __SIG_POWER_H_INCLUDED

#include "sig_boolean.h"
#include "sig_std_logic.h"
#include "sig_gen.h"

struct sig_power_board {
	enum sig_gen_type type;
	struct sig_std_logic *n_ps_on;
	struct sig_boolean *_plus_5Vsb;
	struct sig_boolean *pwr_ok;
	struct sig_boolean *_plus_3_3V;
	struct sig_boolean *_plus_5V;
	struct sig_boolean *_minus_5V;
	struct sig_boolean *_plus_12V;
	struct sig_boolean *_minus_12V;
	struct sig_boolean *gnd;
};

struct sig_power_board_at {
	struct sig_boolean *_plus_5V;
	struct sig_boolean *_minus_5V;
	struct sig_boolean *_plus_12V;
	struct sig_boolean *_minus_12V;
	struct sig_boolean *gnd;
};

struct sig_power_device {
	enum sig_gen_type type;
	struct sig_boolean *power_5V;
	struct sig_boolean *power_12V;
	struct sig_boolean *gnd;
};

extern struct sig_power_board *
sig_power_board_init(const char *name, unsigned int nr);

extern struct sig_power_board_at *
sig_power_board_at_init(const char *name, unsigned int nr);

extern struct sig_power_device *
sig_power_device_init(const char *name, unsigned int nr);

extern void
sig_power_board_create(const char *name, unsigned int nr);
extern void
sig_power_board_destroy(const char *name, unsigned int nr);

extern void
sig_power_board_at_create(const char *name, unsigned int nr);
extern void
sig_power_board_at_destroy(const char *name, unsigned int nr);

extern void
sig_power_device_create(const char *name, unsigned int nr);
extern void
sig_power_device_destroy(const char *name, unsigned int nr);

#endif /* ! __SIG_POWER_H_INCLUDED */
