/*
 * $Id: sig_mem_bus.c,v 1.10 2009-01-27 17:06:41 potyra Exp $
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"
#include <assert.h>
#include <stdio.h>

#include "glue-shm.h"

#include "sig_mem_bus.h"

struct sig_mem_bus_main *
sig_mem_bus_main_init(const char *name, unsigned int nr)
{
	return (struct sig_mem_bus_main *) 0;
}

void
sig_mem_bus_main_create(const char *name, unsigned int nr)
{
}

void
sig_mem_bus_main_destroy(const char *name, unsigned int nr)
{
}

struct sig_mem_bus *
sig_mem_bus_init(const char *name, unsigned int nr)
{
	struct sig_mem_bus *b;
	char n[1000];
	
	b = shm_map(name, nr, sizeof(*b), 0);
	b->type = SIG_GEN_MEM_BUS;

	sprintf(n, "%s-power", name);
	b->power = sig_boolean_init(n, nr);
	sprintf(n, "%s-cs0", name);
	b->cs0 = sig_cs_init(n, nr);
	sprintf(n, "%s-cs1", name);
	b->cs1 = sig_cs_init(n, nr);
	sprintf(n, "%s-i2cbus", name);
	b->i2cbus = sig_i2c_bus_init(n, nr);
	sprintf(n, "%s-id0", name);
	b->id0 = sig_boolean_init(n, nr);
	sprintf(n, "%s-id1", name);
	b->id1 = sig_boolean_init(n, nr);
	sprintf(n, "%s-id2", name);
	b->id2 = sig_boolean_init(n, nr);

	return b;
}

void
sig_mem_bus_create(const char *name, unsigned int nr)
{
	char n[1000];

	shm_create(name, nr, sizeof(struct sig_mem_bus));

	sprintf(n, "%s-power", name);
	sig_boolean_create(n, nr);
	sprintf(n, "%s-cs0", name);
	sig_cs_create(n, nr);
	sprintf(n, "%s-cs1", name);
	sig_cs_create(n, nr);
	sprintf(n, "%s-i2cbus", name);
	sig_i2c_bus_create(n, nr);
	sprintf(n, "%s-id0", name);
	sig_boolean_create(n, nr);
	sprintf(n, "%s-id1", name);
	sig_boolean_create(n, nr);
	sprintf(n, "%s-id2", name);
	sig_boolean_create(n, nr);
}

void
sig_mem_bus_destroy(const char *name, unsigned int nr)
{
	char n[1000];

	shm_destroy(name, nr);

	sprintf(n, "%s-power", name);
	sig_boolean_destroy(n, nr);
	sprintf(n, "%s-cs0", name);
	sig_cs_destroy(n, nr);
	sprintf(n, "%s-cs1", name);
	sig_cs_destroy(n, nr);
	sprintf(n, "%s-i2cbus", name);
	sig_i2c_bus_destroy(n, nr);
	sprintf(n, "%s-id0", name);
	sig_boolean_destroy(n, nr);
	sprintf(n, "%s-id1", name);
	sig_boolean_destroy(n, nr);
	sprintf(n, "%s-id2", name);
	sig_boolean_destroy(n, nr);
}
