/* $Id: RegisterFactory.hpp 4502 2009-04-21 16:00:59Z potyra $ 
 *
 * RegisterFactory: create and keep track of virtual registers.
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */


#ifndef __REGISTER_FACTORY_HPP_INCLUDED
#define __REGISTER_FACTORY_HPP_INCLUDED

#include "intermediate/operands/Register.hpp"

namespace intermediate {

//FIXME nest class in CodeContainer
//! create virtual register (operands).
/** TODO keep better track of handed out vregs?
 */
class RegisterFactory {
private:
	friend class CodeContainer;

	//! c'tor
	RegisterFactory() : cnt(0) {}

	//! create a virtual Register.
	/** @param type type of the virtual register operand
	 *  @return newly created virtual register.
	 */
	Register *
	getReg(enum OpType type);

	/** return the number of created virtual registers.
	 *  @return number of created virtual registers.
	 */
	unsigned int getNumUsedRegs(void) const;

	//! counter of virtual registers.
	unsigned int cnt;
};

}; /* namespace intermediate */

#endif /* __REGISTER_FACTORY_HPP_INCLUDED */
