/* $Id: Update.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Update: update a signal (intermediate opcode)
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __UPDATE_HPP_INCLUDED
#define __UPDATE_HPP_INCLUDED

#include "intermediate/opcodes/OpCode.hpp"
#include <cassert>
#include "intermediate/operands/Operand.hpp"

namespace intermediate {

//! update a given driver
/** This class will update a given driver after a given delay, assuming the
 *  initial transport mechanism.
 *
 *  Read operands src, delay
 *  Write operands: trg 
 *
 *  src: source value of the operation (any type allowed)
 *  delay: delay value (integer)
 *  dst: DirectOperand pointing to the driver (pointer)
 *
 *  Operation: call to the kernel, to add <src,delay> to given driver.
 */
class Update : public OpCode {
public:
	Update(
		Operand *source,
		Operand *delayOp,
		Operand *dest
		) :	src(source), delay(delayOp), dst(dest) {

		assert(delay->type == OP_TYPE_INTEGER);
		assert(dst->type == OP_TYPE_POINTER);
	}

	//! Accept a Visitor.
 	/** All intermediate code nodes need to implement this method.
         *
         *  @param v the Visitor that can visit this node.
         */
	virtual void accept(Visitor& v) {
		v.visit(*this);
	}

	//! source operand
	Operand *src;
	//! delay operand
	Operand *delay;
	//! destination operand
	Operand *dst;

protected:
	virtual ~Update() {
		util::MiscUtil::terminate(this->src);
		util::MiscUtil::terminate(this->delay);
		util::MiscUtil::terminate(this->dst);
	}
};

}; /* namespace intermediate */

#endif /* __UPDATE_HPP_INCLUDED */
