/***************************************************************************
                          FLSqlQuery.cpp  -  description
                             -------------------
    begin                : sb jun 22 2002
    copyright            : (C) 2002 by Federico Albujer Zornoza
    email                : mail@infosial.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "FLApplication.h"
#include "FLSqlQuery.h"
#include "FLParameterQuery.h"
#include "FLGroupByQuery.h"
#include "FLManager.h"

FLSqlQuery::FLSqlQuery ():
QSqlQuery (), name_ (QString::null), select_ (QString::null),
from_ (QString::null), where_ (QString::null), fieldList_ (0), parameterDict_ (0), groupDict_ (0)
{
}

FLSqlQuery::~FLSqlQuery ()
{
  if (parameterDict_)
	{
	  parameterDict_->clear ();
	  delete parameterDict_;
	}
  if (groupDict_)
	{
	  groupDict_->clear ();
	  delete groupDict_;
	}
  if (fieldList_)
	{
	  fieldList_->clear ();
	  delete fieldList_;
	}
}

void
FLSqlQuery::setSelect (const QString & s)
{
  select_ = s.stripWhiteSpace ();
  select_ = select_.simplifyWhiteSpace ();
  if (fieldList_)
	{
	  fieldList_->clear ();
	  delete fieldList_;
	}

  fieldList_ = new QStringList (QStringList::split (QString (","), s));
  if (fieldList_)
	for (QStringList::Iterator it = fieldList_->begin (); it != fieldList_->end (); ++it)
	  (*it) = (*it).stripWhiteSpace ();
}

const QString
FLSqlQuery::sql () const
{
  QString res;
  if ( where_.isEmpty() )
	res = "SELECT " + select_ + " FROM " + from_;
  else
	res = "SELECT " + select_ + " FROM " + from_ + " WHERE " + where_ ;

	if (groupDict_)
		{
			res += "ORDER BY ";
			QDictIterator < FLGroupByQuery > itg (*groupDict_);
			for (int i = 0; itg.current (); ++itg, i++)
				{
  					if (i == 0)
						res += itg.current ()->field ();
  					else
						res += " ," + itg.current ()->field ();
				}
			res += ";";
		}

  if (parameterDict_)
	{
  		QDictIterator < FLParameterQuery > it (*parameterDict_);
  		for (; it.current (); ++it)
			{
	  			QVariant v = it.current ()->value ();

	  			if (!v.isValid ())
					{
		  				bool ok = true;
		  				v = QVariant (QInputDialog::
						getText (qApp->tr ("Entrada de parmetros de la consulta"), it.current ()->alias (), QLineEdit::Normal, QString::null, &ok, qApp->mainWidget ()));
					}
	  			res = res.replace (QRegExp ("\\[" + it.currentKey () + "\\]"), FLManager::formatValue (it.current ()->type (), v));
			}
		}

  return res;
}

bool
FLSqlQuery::exec ()
{
  return QSqlQuery::exec (sql ());
}

void
FLSqlQuery::setGroupDict (FLGroupByQueryDict * gd)
{
  if (!gd)
	return;

  if (gd->isEmpty ())
	return;

  if (groupDict_)
	{
	  groupDict_->clear ();
	  delete groupDict_;
	}

  groupDict_ = gd;
}

void
FLSqlQuery::setParameterDict (FLParameterQueryDict * pd)
{
  if (!pd)
	return;

  if (pd->isEmpty ())
	return;

  if (parameterDict_)
	{
	  parameterDict_->clear ();
	  delete parameterDict_;
	}

  parameterDict_ = pd;
}

void
FLSqlQuery::addParameter (const FLParameterQuery * p)
{
  if (!parameterDict_)
	{
	  parameterDict_ = new FLParameterQueryDict;
	  parameterDict_->setAutoDelete (true);
	}

  if (p)
	parameterDict_->insert (p->name (), p);
}

void
FLSqlQuery::addGroup (const FLGroupByQuery * g)
{
  if (!groupDict_)
	{
	  groupDict_ = new FLGroupByQueryDict;
	  groupDict_->setAutoDelete (true);
	}

  if (g)
	groupDict_->insert (QString::number (g->level ()), g);
}

QVariant
FLSqlQuery::value (const QString & n)
{
  int i = 0;

  if (!fieldList_)
	return QVariant();

  for (QStringList::Iterator it = fieldList_->begin (); it != fieldList_->end (); ++it, i++)
	if ((*it) == n)
	  return value (i);

  return QVariant ();
}

QVariant
FLSqlQuery::value (int i) const
{
  return QSqlQuery::value (i);
}

QString
FLSqlQuery::posToFieldName (const int p)
{
  int i = 0;

  if (!fieldList_)
	return QString::null;

  for (QStringList::Iterator it = fieldList_->begin (); it != fieldList_->end (); ++it, i++)
	if (i == p)
	  return (*it);

  return QString::null;
}

int
FLSqlQuery::fieldNameToPos (const QString & n)
{
  int i = 0;

  if (!fieldList_)
	return -1;

  for (QStringList::Iterator it = fieldList_->begin (); it != fieldList_->end (); ++it, i++)
	if ((*it) == n)
	  return i;

  return -1;
}

void
FLSqlQuery::showDebug ()
{
  if (!isActive ())
	qWarning ("DEBUG : La consulta no est activa : No se ha ejecutado exec() o la sentencia SQL no es vlida");

  qWarning ("DEBUG : Nombre de la consulta :  " + name_);
  qWarning ("DEBUG : Niveles de agrupamiento : ");

  if (groupDict_)
	{
  		QDictIterator < FLGroupByQuery > it (*groupDict_);
  		for (; it.current (); ++it)
			{
	  			qWarning ("**Nivel : " + QString::number (it.current ()->level ()));
	  			qWarning ("**Campo : " + it.current ()->field ());
			}
	}
  else
		qWarning("**No hay niveles de agrupamiento");

  qWarning ("DEBUG : Parmetros : ");
  if (parameterDict_)
	{
  		QDictIterator < FLParameterQuery > it2 (*parameterDict_);
  		for (; it2.current (); ++it2)
			{
	  			qWarning ("**Nombre : " + it2.current ()->name ());
	  			qWarning ("Alias : " + it2.current ()->alias ());
	  			qWarning ("Tipo : " + QString::number (it2.current ()->type ()));
	  			qWarning ("**Valor : " + it2.current ()->value ().toString ());
			}
	}
  else
	qWarning("**No hay parametros");

  qWarning ("DEBUG : Sentencia SQL : ");
  qWarning (sql ());

  if (!fieldList_)
	{
	  qWarning ("DEBUG ERROR : No hay campos en la consulta.");
	  return;
	}

  qWarning ("DEBUG : Campos de la consulta : ");
  for (QStringList::Iterator it = fieldList_->begin (); it != fieldList_->end (); ++it)
	qWarning ("**" + (*it));


  qWarning ("DEBUG : Contenido de la consulta: ");
  while (next ())
	{
	  QString linea = QString::null;

	  QStringList::Iterator it;
	  for (uint i = 0; i < fieldList_->count (); i++)
		{
		  it = fieldList_->at (i);
		  linea += "__" + value ((*it)).toString ();
		}
	  qWarning (linea);
	}
}
