/***************************************************************************
                          FLReceiver.cpp  -  description
                             -------------------
    begin                : Thu Dec 6 2001
    copyright            : (C) 2001,2002 by Federico Albujer Zornoza
    email                : mail@infosial.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "FLReceiver.h"
#include "FLSqlCursor.h"
#include "FLFormDB.h"
#include "FLManager.h"
#include "FLTableMetaData.h"
#include "FLFieldMetaData.h"

FLReceiver::FLReceiver ():QObject (), sender_ (0), cursor_ (0)
{
}

FLReceiver::~FLReceiver ()
{
}

void
FLReceiver::setCursor (FLSqlCursor * c)
{
  cursor_ = c;
}

void
FLReceiver::setSender (FLFormDB * sender)
{
  sender_ = sender;
}

QVariant FLReceiver::calculateField (const QString &)
{
  return QVariant (0);
}

QVariant
FLReceiver::calculateCounter (const QString & name)
{

  if (!cursor_)
	return QVariant::QVariant ();

  FLTableMetaData *tMD = cursor_->metadata ();

  if (!tMD)
	return QVariant::QVariant ();

  FLFieldMetaData *field = tMD->field (name);

  if (!field)
	return QVariant::QVariant ();

  int type = field->type ();
  unsigned int len = field->length ();
  QString cadena;

  if (type == QVariant::String)
	{
	  FLSqlCursor *auxiliar = new FLSqlCursor (tMD->name ());
	  auxiliar->setSort (auxiliar->index (name));
	  auxiliar->last ();
	  double numero = auxiliar->valueBuffer (name).toDouble ();
	  do
		{
		  numero = numero + 1;
		  cadena = QString::number (numero, 'f', 0);
		  if (cadena.length () < len)
			{
			  QString str;
			  str.fill ('0', (len - cadena.length ()));
			  cadena = str + cadena;
			}
		  auxiliar->setMainFilter (name + "=" + FLManager::formatValue (field, cadena));
		  auxiliar->refresh ();
		}
	  while (auxiliar->size () > 0);
	  return QVariant::QVariant (cadena);
	}

  if (type == QVariant::Double)
	{
	  FLSqlCursor *auxiliar = new FLSqlCursor (tMD->name ());
	  auxiliar->setSort (auxiliar->index (name));
	  auxiliar->last ();
	  double numero = auxiliar->valueBuffer (name).toDouble ();
	  do
		{
		  numero = numero + 1;
		  auxiliar->setMainFilter (name + "=" + FLManager::formatValue (field, cadena));
		  auxiliar->refresh ();
		}
	  while (auxiliar->size () > 0);
	  return QVariant::QVariant (numero);

	}

  return QVariant::QVariant ();

}
