/*   Copyright 2004 The Apache Software Foundation
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.codehaus.jam;

/**
 * <p>Encapsulates comment associated with a package, class,
 * method, and so on.  Although they are often declared in the same
 * place (code comments) JComment is a distinct entity from
 * JAnnotation.</p>
 *
 * @author Patrick Calahan &lt;email: codehaus-at-bea-dot-com&gt;
 */
public interface JComment extends JElement {

  /**
   * Returns the text of this comment.
   */
  public String getText();

  /**
   * Returns the location of this comment in the source, or null if it
   * is unknown.
   */
  public JSourcePosition getSourcePosition();
}
