"""

Interface to bchunk (.cue/.bin to .iso converter)

"""

from tools import which, FALSE
from log4py import Logger, LOGLEVEL_NORMAL

class bchunk:

    cue_file = None
    bin_file = None
    basename = None

    def __init__(self, loglevel = LOGLEVEL_NORMAL):
        """ Class initialization. """
        self.__bchunk_logger = Logger().get_instance(self)
        self.__bchunk_logger.set_loglevel(loglevel)
        self.__bchunk_command = which("bchunk")
        if (self.__bchunk_command == ""):
            self.__bchunk_logger.debug("bchunk executable not found.")

    def available(self):
        """ Returns wether bchunk is available or not. """
        return (self.__bchunk_command != "")

    def command_line(self):
        """ Returns the command line for given parameters. """
        if (self.available() == FALSE):
            return None
        elif (self.basename == None) or (self.bin_file == None) or (self.cue_file == None):
            return None
        else:
            command_line = self.__bchunk_command
            command_line = "%s \"%s\" \"%s\" \"%s\"" % (command_line, self.bin_file, self.cue_file, self.basename)
            return command_line

def test():
    bchunk_test = bchunk()
    print bchunk_test.available()
    bchunk_test.cue_file = "x.cue"
    bchunk_test.bin_file = "x.bin"
    bchunk_test.basename = "output"
    print bchunk_test.command_line()

if (__name__ == "__main__"):
    test()
