"""

This class handles projects (open, close, save, ...)

"""

# Initialize i18n
from constants import localedir, unixname
from tools import gettext

gettext = gettext(unixname, localedir)
gettext.textdomain(unixname)
_ = gettext.gettext

import cPickle
import log4py
import os
import sys

from constants import iconpath, configdirectory, shortcutfile
from time import sleep

# this is for installations with both python-gtk versions
try:
    import pygtk
    pygtk.require('2.0')
except:
    pass

try:
    import gtk
except (RuntimeError, TypeError, NameError), detail:
    logger = log4py.Logger().get_instance()
    logger.error(_("An error occured: %s") % detail)
    sys.exit(1)

try:
    import gtk as gnome
    import gnome.tools
except:
    import gnometools
    gnome.tools = gnometools
    
class Project:

    def __init__(self):
        self.Filename = ""
        self.DataFiles = []
        self.DataVolumeID = ""
        self.DataSize = ""
        self.AudioFiles = []
        self.AudioVolumeID = ""
        self.AudioSize = ""
        self.OtherInfo = None
        self.CancelPressed = gtk.FALSE
        self.__busy__ = gtk.FALSE

    def New(self):
        filedialog = gnome.tools.FileSelectionDialog(multiselection = gtk.FALSE, filetypes = [gnome.tools.EROASTER_PROJECTS, gnome.tools.ALL_FILES], icondir = iconpath)
        filedialog.use_lastdirectory("%s%s%s%slastdirectory.project" % (gnome.tools.get_homedirectory(), os.sep, configdirectory, os.sep))
        filedialog.load_shortcuts_from_file("%s%s%s%s%s" % (gnome.tools.get_homedirectory(), os.sep, configdirectory, os.sep, shortcutfile))
        filedialog.ok_button.connect("clicked", self.SetNewFilename, filedialog.get_directory, filedialog.get_filenames, filedialog.destroy)
        filedialog.close_button.connect("clicked", self.CloseFileDialog, filedialog.destroy)
        filedialog.show()
        self.CancelPressed = gtk.FALSE
        self.__busy__ = gtk.TRUE
        while (self.__busy__ == gtk.TRUE):
            while (gtk.events_pending()):
                gtk.mainiteration()
            sleep(0.01)

    def SetNewFilename(self, args, get_directory, get_filenames, destroy):
        self.__init__()
        self.Filename = "%s/%s" % (get_directory(), get_filenames())
        destroy()
        self.__busy__ = gtk.FALSE

    def CloseFileDialog(self, args, destroy):
        destroy()
        self.CancelPressed = gtk.TRUE
        self.__busy__ = gtk.FALSE

    def Close(self):
        self.__init__()

    def Clear(self):
        self.__init__()

    def Open(self):
        filedialog = gnome.tools.FileSelectionDialog(multiselection = gtk.FALSE, filetypes = [gnome.tools.EROASTER_PROJECTS, gnome.tools.ALL_FILES], icondir = iconpath)
        filedialog.use_lastdirectory("%s%s%s%slastdirectory.project" % (gnome.tools.get_homedirectory(), os.sep, configdirectory, os.sep))
        filedialog.load_shortcuts_from_file("%s%s%s%s%s" % (gnome.tools.get_homedirectory(), os.sep, configdirectory, os.sep, shortcutfile))
        filedialog.ok_button.connect("clicked", self.OpenSetFilename, filedialog.get_directory, filedialog.get_filenames, filedialog.destroy)
        filedialog.close_button.connect("clicked", self.CloseFileDialog, filedialog.destroy)
        filedialog.show()
        self.CancelPressed = gtk.FALSE
        self.__busy__ = gtk.TRUE
        while (self.__busy__ == gtk.TRUE):
            while (gtk.events_pending()):
                gtk.mainiteration()
            sleep(0.01)

    def OpenSetFilename(self, args, get_directory, get_filenames, destroy):
        filename = "%s/%s" % (get_directory(), get_filenames())
        if ((os.path.isfile(filename)) and (not os.path.islink(filename))):
            destroy()
            self.Filename = filename
            file = open(self.Filename, "r")
            try:
                pickler = cPickle.Unpickler(file)
                dict = pickler.load()
                self.DataFiles = dict["DataFiles"]
                self.DataVolumeID = dict["DataVolumeID"]
                self.DataSize = dict["DataSize"]
                self.AudioFiles = dict["AudioFiles"]
                self.AudioVolumeID = dict["AudioVolumeID"]
                self.AudioSize = dict["AudioSize"]
                self.OtherInfo = dict["OtherInfo"]
            except:
                gnome.tools.ErrorDialog(_("Invalid ERoaster Project file !"))
            file.close()
            self.__busy__ = gtk.FALSE

    def Save(self):
        if (self.Filename == ""):
            filedialog = gnome.tools.FileSelectionDialog(multiselection = gtk.FALSE, filetypes = [gnome.tools.EROASTER_PROJECTS, gnome.tools.ALL_FILES], icondir = iconpath, windowtitle = "Save File")
            filedialog.use_lastdirectory("%s%s%s%slastdirectory.project" % (gnome.tools.get_homedirectory(), os.sep, configdirectory, os.sep))
            filedialog.load_shortcuts_from_file("%s%s%s%s%s" % (gnome.tools.get_homedirectory(), os.sep, configdirectory, os.sep, shortcutfile))
            filedialog.ok_button.connect("clicked", self.SaveProjectWithFileSelection, filedialog.get_directory, filedialog.get_filenames, filedialog.destroy)
            filedialog.close_button.connect("clicked", filedialog.destroy)
            filedialog.show()
        else:
            self.SaveProject()

    def SaveProjectWithFileSelection(self,args, get_directory, get_filenames, destroy):
        self.Filename = "%s%s%s" % (get_directory(), os.sep, get_filenames())
        destroy()
        self.SaveProject()

    def SaveProject(self):
        dict = {}
        dict["DataFiles"] = self.DataFiles
        dict["DataVolumeID"] = self.DataVolumeID
        dict["DataSize"] = self.DataSize
        dict["AudioFiles"] = self.AudioFiles
        dict["AudioVolumeID"] = self.AudioVolumeID
        dict["AudioSize"] = self.AudioSize
        dict["OtherInfo"] = self.OtherInfo
        file = open(self.Filename, "w")
        pickler = cPickle.Pickler(file)
        pickler.dump(dict)
        file.close()
