require 'erb'

class MyWriter 
  include ERB::Util
  extend ERB::DefMethod

  def_erb_method('error_page(q)', 'err.rhtml')
  def_erb_method('succ_page(q)', 'succ.rhtml')

  def initialize(user)
    @user = user
  end
  attr_reader(:user)

  def query(q)
    if /ruby/i =~ q
      succ_page(q)
    else
      error_page(q)
    end
  end
end

mw = MyWriter.new("mas")

puts mw.query("hello")

puts mw.query("I like Ruby.")
